package com.biz.crm.tpm.business.audit.fee.validation.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Description:差异费用结案明细抵扣差异费用台账记录表
 * @Author qiancheng
 * @Date 2023/11/22
 */
@Getter
@Setter
@Entity
@TableName("tpm_audit_fee_validation_detail_use_ledger")
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AuditFeeValidationDetailUseLedgerEntity" , description = "商超费用结案核销明细表")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_validation_detail_use_ledger" , comment = "商超费用结案核销明细表")
@Table(name = "tpm_audit_fee_validation_detail_use_ledger", indexes = {@Index(name = "validation_detail_use_ledger_index1", columnList = "audit_detail_code")})
public class AuditFeeValidationDetailUseLedgerEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "核销code" , notes = "核销code")
    @Column(name = "audit_code" , length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销code'")
    private String auditCode;

    @ApiModelProperty(name = "核销明细编码" , notes = "核销明细编码")
    @Column(name = "audit_detail_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销明细编码'")
    private String auditDetailCode;

    @ApiModelProperty(name = "差异追踪编码" , notes = "差异追踪编码")
    @Column(name = "plan_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异追踪编码'")
    private String planCode;

    @ApiModelProperty(name = "差异追踪名称" , notes = "差异追踪名称")
    @Column(name = "plan_name" , length = 255, columnDefinition = "VARCHAR(255) COMMENT '差异追踪名称'")
    private String planName;

    @ApiModelProperty(name = "差异追踪明细编码" , notes = "差异追踪明细编码")
    @Column(name = "detail_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异追踪明细编码'")
    private String detailCode;

    @ApiModelProperty(name = "差异费用台账编码", notes = "差异费用台账编码")
    @Column(name = "fee_diff_ledger_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用台账编码'")
    private String feeDiffLedgerCode;

    /**
     * 操作类型[audit_fee_diff_ledger_operation_type]
     */
    @ApiModelProperty(value = "操作类型[audit_fee_diff_ledger_operation_type]", notes = "")
    @Column(name = "operation_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '操作类型 '")
    private String operationType;

    /**
     * 操作金额
     */
    @ApiModelProperty(name = "recoveredAmount", notes = "操作金额", value = "操作金额")
    @Column(name = "recovered_amount", columnDefinition = "Decimal(24,6) COMMENT '操作金额 '")
    private BigDecimal recoveredAmount;

    /**
     * 是否回退 （审批驳回等，会将抵扣金额（操作金额）回退给差异费用台账
     */
    @ApiModelProperty(value = "是否回退", notes = "")
    @Column(name = "is_returned", nullable = true, length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否回退 '")
    private String isReturned;
}
