package com.biz.crm.tpm.business.audit.fee.validation.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;



/**
 * 商超费用结案核销主表
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Getter
@Setter
@Entity
@TableName("tpm_audit_fee_validation")
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AuditFeeValidationEntity", description = "商超费用结案核销主表")
@Table(name = "tpm_audit_fee_validation")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_validation", comment = "商超费用结案核销主表")
public class AuditFeeValidationEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "核销code", notes = "核销code")
    @Column(name = "audit_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销code'")
    private String auditCode;

    @ApiModelProperty(name = "核销申请名称", notes = "核销申请名称")
    @Column(name = "audit_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '核销申请名称'")
    private String auditName;

    @ApiModelProperty(name = "结案审批状态", notes = "结案审批状态")
    @Column(name = "process_status",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '结案审批状态'")
    private String processStatus;

    @ApiModelProperty(name = "结案审批流程编码", notes = "结案审批流程编码")
    @Column(name = "process_no",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '结案审批流程编码'")
    private String processNo;

    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "本次结案金额汇总", notes = "本次结案金额汇总")
    @Column(name = "this_end_case_total_amount", columnDefinition = "decimal(24,6) COMMENT '本次结案金额汇总'")
    private BigDecimal thisEndCaseTotalAmount;

    @ApiModelProperty("hr组织(部门编码)")
    @Column(name = "org_code",  length = 1024, columnDefinition = "VARCHAR(32) COMMENT 'hr组织(部门编码)'")
    private String orgCode;

    @ApiModelProperty("hr组织名称（部门名称）")
    @Column(name = "org_name",  length = 1024, columnDefinition = "VARCHAR(255) COMMENT 'hr组织名称（部门名称）'")
    private String orgName;

    @ApiModelProperty("审批时间")
    @Column(name = "process_date",   columnDefinition = "DATETIME COMMENT '审批时间'")
    private Date processDate;

    /**
     * 保存类型
     */
    @ApiModelProperty(name = "保存类型", notes = "")
    @Column(name = "save_type", length = 1, columnDefinition = "VARCHAR(1) COMMENT '保存类型'")
    private String saveType;

    /**
     * 区域编码(字典MDM_CUSTOMIZE_ORG)
     */
    @ApiModelProperty(name = "区域编码", notes = "")
    @Column(name = "region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

}
