package com.biz.crm.tpm.business.audit.fee.validation.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 商超费用结案核销主表
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Getter
@Setter
@Entity
@TableName("tpm_audit_fee_validation_info")
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AuditFeeValidationInfoEntity", description = "核销资料")
@Table(name = "tpm_audit_fee_validation_info")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_validation_info", comment = "核销资料")
public class AuditFeeValidationInfoEntity extends TenantFlagOpEntity {
    @ApiModelProperty(name = "核销code", notes = "核销code")
    @Column(name = "audit_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销code'")
    private String auditCode;

    @ApiModelProperty(name = "活动形式code", notes = "活动形式code")
    @Column(name = "activity_form_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式code'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "描述", notes = "描述")
    @Column(name = "description",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '描述'")
    private String description;
}
