package com.biz.crm.tpm.business.audit.fee.validation.local.helper;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.constant.AuditFeeValidationConstant;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.enums.SaveTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 商超费用结案核销主表 助手
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Slf4j
@Component
public class AuditFeeValidationHelper {

  @Resource
  private GenerateCodeService generateCodeService;

  @Value("${spring.application.name:}")
  private String applicationName;

  @Autowired(required = false)
  private ChannelMsgService channelMsgService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 头编码
   * @param
   * @return {@link String}
   */
  public String generateCode() {
    //生成编码
    return this.generateCodeService.generateCode(AuditFeeValidationConstant.AUDIT_FEE_DIFF_VALIDATION, 1).get(0);
  }

  /**
   * 明细编码
   * @param number
   * @return {@link List}<{@link String}>
   */
  public List<String> generateDetailCodes(Integer number) {
    return this.generateCodeService.generateCode(AuditFeeValidationConstant.AUDIT_FEE_DIFF_VALIDATION_DETAIL, number);
  }

  /**
   * 参数校验
   * @param dto
   */
  public void verifyParams(AuditFeeValidationDto dto) {
    Validate.notNull(dto,"输入参数不能为空");
    Validate.notBlank(dto.getCacheKey(),"缓存key不能为空");
    if(YesOrNoEnum.YES.getCode().equals(dto.getIsEdit())){
      //编辑校验
      Validate.notBlank(dto.getId(),"编辑id不能为空");
    }else {

    }
    if(SaveTypeEnum.SAVE.getCode().equals(dto.getSaveType())||SaveTypeEnum.SUBMIT.getCode().equals(dto.getSaveType())){

    }
  }

  public void verifyDetails(String saveType,List<AuditFeeValidationDetailDto> detailDtos) {
    Validate.isTrue(!CollectionUtils.isEmpty(detailDtos),"明细不能为空");
    if(SaveTypeEnum.SAVE.getCode().equals(saveType)||SaveTypeEnum.SUBMIT.getCode().equals(saveType)){
      detailDtos.forEach(detail -> {
        Validate.notNull(detail.getThisAuditAmount(),"本次结案金额不能为空");
        Validate.notBlank(detail.getWholeAudit(),"是否完全结案不能为空");
      });
    }
    Map<String, List<AuditFeeValidationDetailDto>> detailDtoMap = detailDtos.stream().collect(Collectors.groupingBy(AuditFeeValidationDetailDto::getDetailCode));
    for (String key : detailDtoMap.keySet()) {
      List<AuditFeeValidationDetailDto> detaiList = detailDtoMap.get(key);
      if (!CollectionUtils.isEmpty(detaiList) && detaiList.size() >= 2){
        throw new IllegalArgumentException("当前明细行中，追踪明细【"+detaiList.get(0).getDetailCode()+"】重复选择了");
      }
    }
  }

  public void sendMsg(String remark){
    sendMsg(remark, ExecStatusEnum.RUNNING.getKey());
  }
  /**
   * 发送进度消息
   */
  public void sendMsg(String remark,String execStatus) {
    JSONObject jsonObject = new JSONObject();
    jsonObject.put("remark",remark);
    String time = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN);
    jsonObject.put("time",time);
    jsonObject.put("applicationName",applicationName);
    jsonObject.put("execStatus",execStatus);
    byte[] jsonBytes = JSONObject.toJSONBytes(jsonObject);
    String tenantCode = TenantUtils.getTenantCode();
    //所有业务所属通道标识
    String modelCode = AuditFeeValidationConstant.WEBSOCKET_MODEL_CODE_BATCH_RELEVANCE;
    log.info(" 批量关联 model send msg: tenantCode = {} , applicationName = {} , modelCode = {} ,remark = {}", tenantCode, applicationName, modelCode,remark);
    UserIdentity loginUser = loginUserService.getLoginUser();
    //公共导入通道
    this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, applicationName, modelCode, loginUser.getAccount(), jsonBytes);
  }
}