package com.biz.crm.tpm.business.audit.fee.validation.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationEntity;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商超费用结案核销主表
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
public interface AuditFeeValidationMapper extends BaseMapper<AuditFeeValidationEntity> {

  /**
   * 主列表
   * @param page
   * @param dto
   * @return {@link Page}<{@link AuditFeeValidationVo}>
   */
  Page<AuditFeeValidationVo> findByConditions(Page<AuditFeeValidationVo> page, @Param("dto") AuditFeeValidationDto dto);

  /**
   * 条件查询单个对象
   * @param dto
   * @return {@link AuditFeeValidationVo}
   */
  AuditFeeValidationVo findOne(@Param("dto") AuditFeeValidationDto dto);

  /**
   * 条件查询多个对象
   * @param dto
   * @return {@link List}<{@link AuditFeeValidationVo}>
   */
  List<AuditFeeValidationVo> findListVo(@Param("dto") AuditFeeValidationDto dto);

  List<String> findProcessStatusNotPass(@Param("detailCodeList") List<String> detailCodeList);
}
