package com.biz.crm.tpm.business.audit.fee.validation.local.register;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailLedgerVo;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationDetailUseLedgerEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationDetailUseLedgerService;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.constant.AuditFeeValidationConstant;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUseLedgerVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/10/14  10:18
 * @Description: 审批回调
 */
@Component
@Slf4j
public class AuditFeeValidationListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;

    @Autowired(required = false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;

    @Autowired(required = false)
    private AuditFeeValidationService auditFeeValidationService;

    @Autowired(required = false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    @Autowired(required = false)
    private AuditFeeValidationDetailUseLedgerService auditFeeValidationDetailUseLedgerService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onProcessComplete(ProcessStatusDto dto) {

        log.info("差异费用结案审批流回调，参数【{}】", JSON.toJSONString(dto));
        String auditCode = dto.getBusinessNo();
        Validate.notEmpty(auditCode, "差异费用结案审批成功回调,提交数据为空");
        AuditFeeValidationVo auditHandles = this.auditFeeValidationService.findConditionByAuditCode(auditCode);
        Validate.notNull(auditHandles,"根据业务编码，未找到对应的差异费用结案数据！");
        String currentOperateId = new Snowflake().nextIdStr();
        try {

            log.info("差异费用结案审批流回调更新状态");
            this.auditFeeValidationService.updateProcessStatusByAuditCode(auditHandles.getAuditCode(), ProcessStatusEnum.getStatusEnumByDictCode(dto.getProcessStatus()), dto.getProcessNo());

            if (CollectionUtils.isEmpty(auditHandles.getDetailList())) {
                log.info("差异费用结案审批流回调auditCode:{},明细为空");
                return;
            }
            //操作差异费用台账
            if (StringUtils.equals(dto.getProcessStatus(), ProcessStatusEnum.PASS.getDictCode())) {

                this.operateAmount(currentOperateId, dto.getProcessStatus(), auditHandles.getDetailList());

            } else if ((StringUtils.equals(dto.getProcessStatus(), ProcessStatusEnum.REJECT.getDictCode()))
                    || StringUtils.equals(dto.getProcessStatus(), ProcessStatusEnum.RECOVER.getDictCode())) {

                this.operateAmount(currentOperateId, dto.getProcessStatus(), auditHandles.getDetailList());
            }
            //更新追踪
            if (StringUtils.equals(dto.getProcessStatus(), ProcessStatusEnum.PASS.getDictCode())) {
                List<AuditFeeDiffTrackDetailDto> updateList = new ArrayList<>();
                auditHandles.getDetailList().forEach(detail -> {
                    AuditFeeDiffTrackDetailDto trackDetailDto = new AuditFeeDiffTrackDetailDto();
                    trackDetailDto.setPlanCode(detail.getPlanCode());
                    trackDetailDto.setDetailCode(detail.getDetailCode());
                    trackDetailDto.setAlreadyAuditAmount(detail.getThisAuditAmount());
                    trackDetailDto.setWholeAudit(detail.getWholeAudit());
                    updateList.add(trackDetailDto);
                });
                this.auditFeeDiffTrackDetailVoService.updateAlreadyAuditAmountByValidationPass(updateList);
            }
        }catch (Exception e) {
            log.error("差异费用结案审批流回调失败");
            throw e;
        } finally {
            log.info("差异费用结案审批流回调解锁");
            String redisKey = String.format(AuditFeeValidationConstant.AUDIT_FEE_VALIDATION_AMOUNT_LOCK, currentOperateId);
            if (this.redisService.hasKey(redisKey)) {
                List<String> obj = (List<String>) this.redisService.get(redisKey);
                this.auditFeeDiffLedgerLockService.unlock(obj);
                this.redisService.del(redisKey);
            }
        }
    }

    @Override
    public String getBusinessCode() {
        return AuditFeeValidationConstant.TPM_AUDIT_FEE_PROCESS;
    }

    //处理需要扣减的明细行
    private void operateAmount(String currentOperateId, String processStatus, List<AuditFeeValidationDetailVo> details) {
        log.info("差异费用结案审批流回调处理需要扣减的明细行");
        if (CollectionUtils.isEmpty(details)) return;
        FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);

        //差异追踪及其关联的差异费用台账map （审批通过且完全结案使用）
        Map<String, List<AuditFeeDiffTrackDetailLedgerVo>> ledgerVoMap = new HashMap<>();
        //差异费用台账原表数据map （审批通过且完全结案使用）
        Map<String, AuditFeeDiffLedgerVo> diffLedgerVoMap = new HashMap<>();
        //差异结案明细及其抵扣台账map（审批驳回追回使用）
        Map<String, List<AuditFeeValidationDetailUseLedgerVo>> useLegerVoListMap = new HashMap<>();
        //更新差异结案抵扣记录list
        List<String> useLedgerIdList = new ArrayList<>();

        if (StringUtils.equals(processStatus, ProcessStatusEnum.PASS.getDictCode())) {
            //完全结案的编码
            List<String> detailCodes = details.stream().filter(f -> BooleanEnum.TRUE.getCapital().equals(f.getWholeAudit())).map(AuditFeeValidationDetailVo::getDetailCode).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(detailCodes)) {
                //查询结案明细对应的差异台账数据
                List<AuditFeeDiffTrackDetailLedgerVo> ledgers = this.auditFeeDiffTrackDetailVoService.findLedgerByDetailCodes(detailCodes);
                Validate.notEmpty(ledgers,"未查询到差异费用追踪相关联的差异费用台账!");
                ledgerVoMap = ledgers.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailLedgerVo::getDetailCode));

                /*List<String> feeDiffLedgerCodes = ledgers.stream().map(AuditFeeDiffTrackDetailLedgerVo::getFeeDiffLedgerCode).distinct().collect(Collectors.toList());
                //查询差异费用台账预算原数据
                List<AuditFeeDiffLedgerVo> diffLegerVoList = this.auditFeeDiffLedgerVoService.findDetailByCodes(feeDiffLedgerCodes);
                Validate.notEmpty(diffLegerVoList,"未查询到差异费用台账信息！");
                diffLedgerVoMap = diffLegerVoList.stream().collect(Collectors.toMap(AuditFeeDiffLedgerVo::getFeeDiffLedgerCode, Function.identity(), (v1, v2) -> v2));
*/
            }

        }
        if (StringUtils.equals(processStatus, ProcessStatusEnum.REJECT.getDictCode())
                || StringUtils.equals(processStatus, ProcessStatusEnum.RECOVER.getDictCode())) {
            List<String> auditDetailCodes = details.stream().map(AuditFeeValidationDetailVo::getAuditDetailCode).distinct().collect(Collectors.toList());
            //查询结案明细对应的抵扣台账记录
            List<AuditFeeValidationDetailUseLedgerVo> useLedgerVoList = auditFeeValidationDetailUseLedgerService.findByAuditDetailCodes(auditDetailCodes);
            if (!CollectionUtils.isEmpty(useLedgerVoList)) {

                useLegerVoListMap = useLedgerVoList.stream().collect(Collectors.groupingBy(AuditFeeValidationDetailUseLedgerVo::getAuditDetailCode));
            }
        }

        List<AuditFeeDiffLedgerDeductionDto> operateDto = Lists.newArrayList();
        //通过的时候要根据完全结案标记来 多退
        //驳回、追回的时候要根据 提交是否有少补，有就退回
        for (AuditFeeValidationDetailVo detail : details) {
            //审批通过的时候要根据完全结案标记来 多退
            if (StringUtils.equals(processStatus, ProcessStatusEnum.PASS.getDictCode()) && BooleanEnum.TRUE.getCapital().equals(detail.getWholeAudit())) {
                BigDecimal amount = ObjectUtils.defaultIfNull(detail.getAlreadyAuditAmount(), BigDecimal.ZERO).add(detail.getThisAuditAmount());
                if (amount.compareTo(detail.getApplyAmount()) < 0 ) {

                    if (CollectionUtils.isEmpty(ledgerVoMap) || CollectionUtils.isEmpty(ledgerVoMap.get(detail.getDetailCode()))) {
                        throw new RuntimeException("差异费用追踪【"+detail.getDetailCode()+"】,没有关联的差异费用台账，无法回退金额");
                    }

                    //待回退金额
                    BigDecimal returnAmountTotal = detail.getApplyAmount().subtract(amount);

                    List<AuditFeeDiffTrackDetailLedgerVo> detailLedgerVoList = ledgerVoMap.get(detail.getDetailCode());
                    //按时间倒序排序
                    detailLedgerVoList.stream().sorted(Comparator.comparing(AuditFeeDiffTrackDetailLedgerVo::getFeeDiffLedgerCode).reversed()).collect(Collectors.toList());

                    for (AuditFeeDiffTrackDetailLedgerVo auditFeeDiffTrackDetailLedgerVo : detailLedgerVoList) {
                        if (returnAmountTotal.compareTo(BigDecimal.ZERO) == 0) {
                            break;
                        }
                        //差异费用台账
                        /*
                        AuditFeeDiffLedgerVo auditFeeDiffLedgerVo = diffLedgerVoMap.get(auditFeeDiffTrackDetailLedgerVo.getFeeDiffLedgerCode());
                        if (Objects.isNull(auditFeeDiffLedgerVo)) {
                            continue;
                        }*/

                        BigDecimal usedAmount = Optional.ofNullable(auditFeeDiffTrackDetailLedgerVo.getUsedAmount()).orElse(BigDecimal.ZERO);
                        //台账的已追回金额 BigDecimal recoveredAmount = Optional.ofNullable(auditFeeDiffLedgerVo.getRecoveredAmount()).orElse(BigDecimal.ZERO);
                        if (usedAmount.compareTo(BigDecimal.ZERO) == 0) {
                            continue;
                        }

                        AuditFeeDiffLedgerDeductionDto dto = new AuditFeeDiffLedgerDeductionDto();
                        dto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode());
                        dto.setFeeDiffLedgerCode(auditFeeDiffTrackDetailLedgerVo.getFeeDiffLedgerCode());
                        dto.setDataSource(DiffLedgerDataSourceEnum.DIFF_CLOSED.getCode());
                        dto.setBusinessCode(detail.getAuditDetailCode());
                        dto.setFeeDiffLedgerDisposeCode(detail.getDetailCode());
                        dto.setActivityFormCode(detail.getActivityFormCode());
                        dto.setActivityFormName(detail.getActivityFormName());
                        dto.setActivityTypeCode(detail.getActivityTypeCode());
                        dto.setActivityTypeName(detail.getActivityTypeName());
                        dto.setResaleCommercialCode(detail.getSystemCode());
                        dto.setResaleCommercialName(detail.getSystemName());
                        dto.setTerminalCode(detail.getTerminalCode());
                        dto.setTerminalName(detail.getTerminalName());
                        if (!Objects.isNull(loginUserDetails)){
                            dto.setOperatorAccount(loginUserDetails.getAccount());
                        }
                        if (returnAmountTotal.compareTo(usedAmount) > 0) {

                            dto.setRecoveredAmount(usedAmount);
                            returnAmountTotal = returnAmountTotal.subtract(usedAmount);
                        }else {
                            dto.setRecoveredAmount(returnAmountTotal);
                            returnAmountTotal = BigDecimal.ZERO;
                        }

                        operateDto.add(dto);
                    }

                }
            }
            //驳回、追回的时候要根据 提交是否有少补，有就退回
            if (StringUtils.equals(processStatus, ProcessStatusEnum.REJECT.getDictCode())
                    || StringUtils.equals(processStatus, ProcessStatusEnum.RECOVER.getDictCode())) {
                BigDecimal amount = ObjectUtils.defaultIfNull(detail.getAlreadyAuditAmount(), BigDecimal.ZERO).add(detail.getThisAuditAmount());
                if (amount.compareTo(detail.getApplyAmount()) > 0 ) {

                    if (CollectionUtils.isEmpty(useLegerVoListMap) || CollectionUtils.isEmpty(useLegerVoListMap.get(detail.getAuditDetailCode()))) {
                        continue;
                    }
                    List<AuditFeeValidationDetailUseLedgerVo> auditFeeValidationDetailUseLedgerVos = useLegerVoListMap.get(detail.getAuditDetailCode());

                    for (AuditFeeValidationDetailUseLedgerVo useLedgerVo : auditFeeValidationDetailUseLedgerVos) {
                        AuditFeeDiffLedgerDeductionDto dto = new AuditFeeDiffLedgerDeductionDto();
                        dto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode());
                        dto.setRecoveredAmount(useLedgerVo.getRecoveredAmount());
                        dto.setFeeDiffLedgerCode(useLedgerVo.getFeeDiffLedgerCode());
                        dto.setDataSource(DiffLedgerDataSourceEnum.DIFF_CLOSED.getCode());
                        dto.setBusinessCode(detail.getAuditDetailCode());
                        dto.setFeeDiffLedgerDisposeCode(detail.getDetailCode());
                        dto.setActivityFormCode(detail.getActivityFormCode());
                        dto.setActivityFormName(detail.getActivityFormName());
                        dto.setActivityTypeCode(detail.getActivityTypeCode());
                        dto.setActivityTypeName(detail.getActivityTypeName());
                        dto.setResaleCommercialCode(detail.getSystemCode());
                        dto.setResaleCommercialName(detail.getSystemName());
                        dto.setTerminalCode(detail.getTerminalCode());
                        dto.setTerminalName(detail.getTerminalName());
                        if (!Objects.isNull(loginUserDetails)){
                            dto.setOperatorAccount(loginUserDetails.getAccount());
                        }
                        operateDto.add(dto);
                        useLedgerIdList.add(useLedgerVo.getId());
                    }
                }
            }

        }

        if (CollectionUtils.isEmpty(operateDto)) return;
        log.info("差异费用结案审批流回调开始进行扣减明细");
        this.auditFeeValidationService.operateAmount(currentOperateId,operateDto);
        if (!CollectionUtils.isEmpty(useLedgerIdList)) {
            log.info("差异费用结案审批流回调开始更新抵扣记录的回退标记");
            this.auditFeeValidationDetailUseLedgerService.updateIsReturned(useLedgerIdList,BooleanEnum.TRUE.getCapital());
        }
    }
}
