package com.biz.crm.tpm.business.audit.fee.validation.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationInfoAttachmentEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationInfoEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.mapper.AuditFeeValidationInfoAttachmentMapper;
import com.biz.crm.tpm.business.audit.fee.validation.local.mapper.AuditFeeValidationInfoMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description 核销资料
 * @Author wei·yang
 * @Date Created in 2023/9/28 13:48
 */
@Component
public class AuditFeeValidationInfoAttachmentRepository extends ServiceImpl<AuditFeeValidationInfoAttachmentMapper, AuditFeeValidationInfoAttachmentEntity> {

    /**
     * 删除数据
     * @param auditCode
     */
    public void deleteByAuditCode(String auditCode) {
        this.lambdaUpdate().eq(AuditFeeValidationInfoAttachmentEntity::getAuditCode, auditCode).remove();
    }

    /**
     * 查询核销资料附件
     * @param auditCode
     * @return {@link List}<{@link AuditFeeValidationInfoAttachmentEntity}>
     */
    public List<AuditFeeValidationInfoAttachmentEntity> findByAuditCode(String auditCode) {
        return this.lambdaQuery().eq(AuditFeeValidationInfoAttachmentEntity::getAuditCode, auditCode).list();
    }
}
