package com.biz.crm.tpm.business.audit.fee.validation.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationInfoEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.mapper.AuditFeeValidationInfoMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description 核销资料
 * @Author wei·yang
 * @Date Created in 2023/9/28 13:48
 */
@Component
public class AuditFeeValidationInfoRepository extends ServiceImpl<AuditFeeValidationInfoMapper, AuditFeeValidationInfoEntity> {

    /**
     * 删除数据
     * @param auditCode
     */
    public void deleteByAuditCode(String auditCode) {
        this.lambdaUpdate().eq(AuditFeeValidationInfoEntity::getAuditCode, auditCode).remove();
    }

    /**
     * 核销资料
     * @param auditCode
     * @return {@link List}<{@link AuditFeeValidationInfoEntity}>
     */
    public List<AuditFeeValidationInfoEntity> findByAuditCode(String auditCode) {
        return this.lambdaQuery().eq(AuditFeeValidationInfoEntity::getAuditCode, auditCode).list();
    }
}
