package com.biz.crm.tpm.business.audit.fee.validation.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.mapper.AuditFeeValidationMapper;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

/**
 * 商超费用结案核销主表 数据层
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Component
public class AuditFeeValidationRepository extends ServiceImpl<AuditFeeValidationMapper, AuditFeeValidationEntity> {

  /**
   * 主列表
   * @param pageable
   * @param dto
   * @return {@link Page}<{@link AuditFeeValidationVo}>
   */
  public Page<AuditFeeValidationVo> findByConditions(Pageable pageable, AuditFeeValidationDto dto) {
    Page<AuditFeeValidationVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 条件查询单个对象
   * @param dto
   * @return {@link AuditFeeValidationVo}
   */
  public AuditFeeValidationVo findOne(AuditFeeValidationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return this.baseMapper.findOne(dto);
  }

  /**
   * 条件查询多个对象
   * @param dto
   * @return {@link AuditFeeValidationVo}
   */
  public List<AuditFeeValidationVo> findListVo(AuditFeeValidationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return this.baseMapper.findListVo(dto);
  }

  /**
   * 删除
   * @param ids
   */
  public void deleteBatch(List<String> ids) {
    this.lambdaUpdate()
        .eq(AuditFeeValidationEntity::getTenantCode, TenantUtils.getTenantCode())
        .in(AuditFeeValidationEntity::getId, ids)
        .set(AuditFeeValidationEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 启用
   * @param ids
   * @return
   */
  public void enableBatch(List<String> ids) {
    this.lambdaUpdate()
        .eq(AuditFeeValidationEntity::getTenantCode, TenantUtils.getTenantCode())
        .in(AuditFeeValidationEntity::getId, ids)
        .set(AuditFeeValidationEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .update();
  }

  /**
   * 禁用
   * @param ids
   * @return
   */
  public void disableBatch(List<String> ids) {
    this.lambdaUpdate()
        .eq(AuditFeeValidationEntity::getTenantCode, TenantUtils.getTenantCode())
        .in(AuditFeeValidationEntity::getId, ids)
        .set(AuditFeeValidationEntity::getEnableStatus, EnableStatusEnum.DISABLE.getCode())
        .update();
  }

  public void updateProcessStatusByAuditCode(String auditCode, ProcessStatusEnum commit, String processNo) {
    if(StringUtils.isEmpty(auditCode)){
      return;
    }
    this.lambdaUpdate().eq(AuditFeeValidationEntity::getAuditCode,auditCode)
            .set(StringUtils.isNotEmpty(processNo),AuditFeeValidationEntity::getProcessNo,processNo)
            .set(StringUtils.isNotEmpty(commit.getDictCode()),AuditFeeValidationEntity::getProcessStatus,commit.getDictCode())
            .set(AuditFeeValidationEntity::getProcessDate,new Date())
            .update();
  }

  public AuditFeeValidationEntity findByAuditCode(String auditCode) {
    if(StringUtils.isEmpty(auditCode)){
      return null;
    }
    AuditFeeValidationEntity one = this.lambdaQuery().eq(AuditFeeValidationEntity::getAuditCode, auditCode).one();
    return one;
  }

  public List<String> findProcessStatusNotPass(List<String> detailCodeList) {
    if (CollectionUtils.isEmpty(detailCodeList)) return Collections.emptyList();
    return baseMapper.findProcessStatusNotPass(detailCodeList);
  }
}
