package com.biz.crm.tpm.business.audit.fee.validation.local.service;

import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationInfoVo;

import java.util.List;

/**
 * @Description 核销资料
 * @Author wei·yang
 * @Date Created in 2023/9/28 13:42
 */
public interface AuditFeeValidationInfoService {

    /**
     * 保存核销资料
     * @param auditCode
     * @param isEdit
     * @param auditInfoList
     */
    void createOrUpdate(String auditCode, boolean isEdit, String cacheKey);

    /**
     * 查询核销资料
     * @param auditCode
     * @return {@link List}<{@link AuditFeeValidationInfoVo}>
     */
    List<AuditFeeValidationInfoVo> findByAuditCode(String auditCode);

    /**
     * 核销资料
     * @param dto
     * @return
     */
    List<AuditFeeValidationInfoVo> findAuditInfo(AuditFeeValidationDto dto);

    /**
     * 保存核销资料到缓存中
     * @param dto
     */
    void saveAuditInfoCache(AuditFeeValidationDto dto);
    void saveAuditInfoCache(String cacheKey, List<AuditFeeValidationInfoVo> auditFeeValidationInfoVos);
}
