package com.biz.crm.tpm.business.audit.fee.validation.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationDetailEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.helper.AuditFeeValidationHelper;
import com.biz.crm.tpm.business.audit.fee.validation.local.repository.AuditFeeValidationDetailRepository;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationDetailService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationDetailVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description 明细VoServiceImpl
 * @Author wei·yang
 * @Date Created in 2023/9/27 15:32
 */
@Slf4j
@Service("auditFeeValidationDetailService")
public class AuditFeeValidationDetailServiceImpl implements AuditFeeValidationDetailService {

    @Resource
    private AuditFeeValidationDetailVoService auditFeeValidationDetailVoService;

    @Resource
    private AuditFeeValidationDetailRepository auditFeeValidationDetailRepository;

    @Resource
    private AuditFeeValidationHelper auditFeeValidationHelper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;

    /**
     * 保存明细
     */
    @Override
    public List<AuditFeeValidationDetailDto> createOrUpdate(String auditCode, boolean isEdit, String cacheKey,String saveType) {

        Map<String, AuditFeeValidationDetailDto> detailOldMap = new HashMap<>();
        List<AuditFeeValidationDetailDto> detailDtos = this.auditFeeValidationDetailVoService.findCacheList(cacheKey);
        this.auditFeeValidationHelper.verifyDetails(saveType,detailDtos);
        //已完全结案的差异费用追踪不允许再次结案
        List<String> detailCodes = detailDtos.stream().map(AuditFeeValidationDetailDto::getDetailCode).distinct().collect(Collectors.toList());
        List<String> endCastCodes = auditFeeDiffTrackDetailVoService.findEndCastFormByDetailCodes(detailCodes);
        if (!CollectionUtils.isEmpty(endCastCodes)) {
            StringBuilder errMsg = new StringBuilder();
            if (endCastCodes.size() > 5) {
                endCastCodes.forEach(e -> {
                    errMsg.append(e + ";");
                });
            }
            throw new RuntimeException("差异费用追踪已完全结案,不可再次结案。完全结案追踪明细编码【"+ ( endCastCodes.size() > 5 ? JSONObject.toJSONString(endCastCodes) : errMsg.toString() ) +"】");
        }
        if (isEdit) {
            List<AuditFeeValidationDetailEntity> detailEntityList = this.auditFeeValidationDetailRepository.findByAuditCode(auditCode);
            if (!CollectionUtils.isEmpty(detailEntityList)) {
                Collection<AuditFeeValidationDetailDto> detailDtos2 = this.nebulaToolkitService.copyCollectionByWhiteList(detailEntityList, AuditFeeValidationDetailEntity.class, AuditFeeValidationDetailDto.class, LinkedHashSet.class, ArrayList.class);
                detailOldMap = detailDtos2.stream().collect(Collectors.toMap(AuditFeeValidationDetailDto::getId, Function.identity()));
            }
        }
        List<AuditFeeValidationDetailDto> addData = new ArrayList<>();
        List<AuditFeeValidationDetailDto> updateDate = new ArrayList<>();
        for (AuditFeeValidationDetailDto o : detailDtos) {
            o.setAuditCode(auditCode);
            o.setTenantCode(TenantUtils.getTenantCode());
            AuditFeeValidationDetailDto dto = detailOldMap.get(o.getId());
            if (dto == null) {
                addData.add(o);
            } else {
                updateDate.add(o);
                detailOldMap.remove(o.getId());
            }
        }
        //新增的
        if (!CollectionUtils.isEmpty(addData)) {
            List<String> codes = this.auditFeeValidationHelper.generateDetailCodes(addData.size());
            AtomicInteger index = new AtomicInteger(0);
            addData.forEach(item -> {
                item.setAuditDetailCode(codes.get(index.getAndIncrement()));
            });

            List<AuditFeeValidationDetailEntity> addDataEntitys = (List<AuditFeeValidationDetailEntity>) this.nebulaToolkitService
                    .copyCollectionByWhiteList(addData, AuditFeeValidationDetailDto.class,
                                               AuditFeeValidationDetailEntity.class, HashSet.class, ArrayList.class);
            this.auditFeeValidationDetailRepository.saveBatch(addDataEntitys);
        }
        //编辑的
        if (!CollectionUtils.isEmpty(updateDate)) {
            List<AuditFeeValidationDetailEntity> updateDateEntitys = (List<AuditFeeValidationDetailEntity>) this.nebulaToolkitService
                    .copyCollectionByWhiteList(updateDate, AuditFeeValidationDetailDto.class,
                                               AuditFeeValidationDetailEntity.class, HashSet.class, ArrayList.class);
            this.auditFeeValidationDetailRepository.updateBatchById(updateDateEntitys);
        }
        if (!CollectionUtils.isEmpty(detailOldMap)) {
            this.auditFeeValidationDetailRepository.removeByIds(detailOldMap.keySet());
        }
        return detailDtos;
    }

    @Override
    public void addItemCache(String cacheKey, List<AuditFeeValidationDetailDto> detailDtos) {
        Validate.notBlank(cacheKey, "缓存key不能为空");
        Validate.isTrue(!CollectionUtils.isEmpty(detailDtos), "要缓存的数据不能为空");
        auditFeeValidationDetailVoService.addItemCache(cacheKey, detailDtos);
    }

    /**
     * 根据auditCode找到明细
     * @param auditCode
     * @return
     */
    @Override
    public List<AuditFeeValidationDetailEntity> findByAuditCode(String auditCode) {
        return this.auditFeeValidationDetailRepository.findByAuditCode(auditCode);
    }

    @Override
    public List<AuditFeeValidationDetailDto> findInApprovalValidation(String id,String auditCode,List<String> detailCodes,String processStatus) {
        if (StringUtils.isBlank(auditCode) && CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeValidationDetailDto> list = new ArrayList<>();
        if (!StringUtils.isBlank(auditCode)) {
            list = this.auditFeeValidationDetailRepository.findInApprovalValidation(id,auditCode,processStatus,TenantUtils.getTenantCode());
        }
        if (!CollectionUtils.isEmpty(detailCodes)) {
            list = this.auditFeeValidationDetailRepository.findInApprovalValidation(id,detailCodes,processStatus,TenantUtils.getTenantCode());
        }
        return list;
    }
}
