package com.biz.crm.tpm.business.audit.fee.validation.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationDetailUseLedgerEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.repository.AuditFeeValidationDetailUseLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationDetailUseLedgerService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailUseLedgerDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUseLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/11/22
 */
@Service
public class AuditFeeValidationDetailUseLedgerServiceImpl implements AuditFeeValidationDetailUseLedgerService {

    @Autowired(required = false)
    private AuditFeeValidationDetailUseLedgerRepository auditFeeValidationDetailUseLedgerRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBatch(List<AuditFeeValidationDetailUseLedgerDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        dtoList.forEach(dto -> {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setTenantCode(TenantUtils.getTenantCode());
        });
        Collection<AuditFeeValidationDetailUseLedgerEntity> entityList = nebulaToolkitService.copyCollectionByWhiteList(dtoList, AuditFeeValidationDetailUseLedgerDto.class, AuditFeeValidationDetailUseLedgerEntity.class, HashSet.class, ArrayList.class);
        this.auditFeeValidationDetailUseLedgerRepository.saveBatch(entityList);
    }

    @Override
    public List<AuditFeeValidationDetailUseLedgerVo> findByAuditDetailCodes(List<String> auditDetailCodes) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeValidationDetailUseLedgerEntity> list = this.auditFeeValidationDetailUseLedgerRepository.findByAuditDetailCodes(auditDetailCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeeValidationDetailUseLedgerVo>) nebulaToolkitService.copyCollectionByWhiteList(list,AuditFeeValidationDetailUseLedgerEntity.class,AuditFeeValidationDetailUseLedgerVo.class,HashSet.class,ArrayList.class);
    }

    /**
     * 差异结案审批驳回、追回，更据抵扣记录回退台账金额后，更新已回退标记
     * @param idList
     * @param isReturned
     */
    @Override
    public void updateIsReturned(List<String> idList, String isReturned) {
        if (CollectionUtils.isEmpty(idList) || StringUtils.isBlank(isReturned)) {
            return;
        }
        this.auditFeeValidationDetailUseLedgerRepository.updateIsReturned(idList,isReturned);
    }
}
