package com.biz.crm.tpm.business.audit.fee.validation.local.service.internal;

import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationDetailVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateExportVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateImportVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description 明细VoServiceImpl
 * @Author wei·yang
 * @Date Created in 2023/9/27 15:32
 */
@Slf4j
@Service("auditFeeValidationDetailVoService")
public class AuditFeeValidationDetailVoServiceImpl extends MnPageCacheServiceImpl<AuditFeeValidationDetailVo, AuditFeeValidationDetailDto> implements AuditFeeValidationDetailVoService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    /**
     * 获取缓存中导出总数
     * @param cacheKey
     * @return
     */
    @Override
    public Integer getExportTotal(String cacheKey) {
        return this.findCacheList(cacheKey).size();
    }

    /**
     * 获取缓存中导出数据
     * @param cacheKey
     * @return
     */
    @Override
    public List<AuditFeeValidationDetailUpdateExportVo> getExportData(String cacheKey) {
        List<AuditFeeValidationDetailDto> dtoList = this.findCacheList(cacheKey);

        return (List<AuditFeeValidationDetailUpdateExportVo>)
                this.nebulaToolkitService.copyCollectionByWhiteList(dtoList,
                                                                    AuditFeeValidationDetailDto.class,
                                                                    AuditFeeValidationDetailUpdateExportVo.class,
                                                                    HashSet.class, ArrayList.class);
    }

    /**
     * 明细导入验证
     * @param importsVoList
     * @param cacheKey
     * @param errorMap
     * @return
     */
    @Override
    public List<AuditFeeValidationDetailDto> validate(List<AuditFeeValidationDetailUpdateImportVo> importsVoList, String cacheKey, Map<String, String> errorMap) {
        //根据ID把数据取出来
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        List<AuditFeeValidationDetailDto> dataList = Lists.newArrayList();

        Set<String> yesNo = Sets.newHashSet("是","否");
        //导入的数据
        importsVoList.forEach(e -> {
            Object obj = this.redisTemplate.opsForHash().get(redisCacheDataKey, e.getId());
            if(Objects.isNull(obj)) return;
            AuditFeeValidationDetailDto data = (AuditFeeValidationDetailDto) obj;

            StringBuffer sb = new StringBuffer();
            String thisAuditAmountStr = e.getThisAuditAmountStr();
            String wholeAudit = e.getWholeAudit();

            if(StringUtils.isBlank(thisAuditAmountStr)){
               sb.append("本次结案金额不能为空;");
            }else{
                try{
                    data.setThisAuditAmount(new BigDecimal(thisAuditAmountStr));
                }catch (Exception ex){
                    sb.append("本次结案金额不是数字;");
                }
            }

            if(StringUtils.isBlank(wholeAudit)){
                sb.append("是否完全结案不能为空;");
            }else if(!yesNo.contains(wholeAudit)){
                sb.append("是否完全结案填写错误;");
            }else{
                data.setWholeAudit("是".equals(wholeAudit) ? "1" : "0");
            }

            if(sb.length() > 0){
                errorMap.put(e.getId(),sb.toString());
            }
            dataList.add(data);
        });
        return dataList;
    }

    /**
     * 导入到缓存
     * @param cacheKey
     * @param result
     */
    @Override
    public void imports(String cacheKey, List<AuditFeeValidationDetailDto> result) {
        this.saveCurrentPageCache(cacheKey,result);
    }
}
