package com.biz.crm.tpm.business.audit.fee.validation.local.service.internal;

import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationInfoAttachmentEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.repository.AuditFeeValidationInfoAttachmentRepository;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationInfoAttachmentService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationInfoAttachmentVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @Description
 * @Author wei·yang
 * @Date Created in 2023/9/28 14:07
 */
@Slf4j
@Service("auditFeeValidationInfoAttachmentService")
public class AuditFeeValidationInfoAttachmentServiceImpl implements AuditFeeValidationInfoAttachmentService {

    @Resource
    private AuditFeeValidationInfoAttachmentRepository auditFeeValidationInfoAttachmentRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 保存核销资料附件
     * @param auditCode
     * @param attachmentVos
     */
    @Override
    public void save(String auditCode, List<AuditFeeValidationInfoAttachmentVo> attachmentVos) {
        //删除数据
        this.auditFeeValidationInfoAttachmentRepository.deleteByAuditCode(auditCode);
        if(CollectionUtils.isEmpty(attachmentVos)){
            return;
        }
        List<AuditFeeValidationInfoAttachmentEntity> entities =
                (List<AuditFeeValidationInfoAttachmentEntity>)this.nebulaToolkitService
                        .copyCollectionByWhiteList(attachmentVos, AuditFeeValidationInfoAttachmentVo.class,
                AuditFeeValidationInfoAttachmentEntity.class, HashSet.class, ArrayList.class);
        this.auditFeeValidationInfoAttachmentRepository.saveBatch(entities);
    }

    /**
     * 查询核销资料附件
     * @param auditCode
     * @return {@link List}<{@link AuditFeeValidationInfoAttachmentVo}>
     */
    @Override
    public List<AuditFeeValidationInfoAttachmentVo> findByAuditCode(String auditCode) {
        List<AuditFeeValidationInfoAttachmentEntity> entities = this.auditFeeValidationInfoAttachmentRepository
                .findByAuditCode(auditCode);
        if(CollectionUtils.isEmpty(entities)){
            return null;
        }
        return (List<AuditFeeValidationInfoAttachmentVo>)this.nebulaToolkitService.copyCollectionByWhiteList(entities
                , AuditFeeValidationInfoAttachmentEntity.class, AuditFeeValidationInfoAttachmentVo.class, HashSet.class, ArrayList.class);
    }
}
