/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.cache;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationDetailEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.repository.AuditFeeValidationDetailRepository;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationInfoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationInfoVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AuditFeeValidationDetailCacheHelper
extends MnPageCacheHelper<AuditFeeValidationDetailVo, AuditFeeValidationDetailDto> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeValidationDetailCacheHelper.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFeeValidationDetailRepository auditFeeValidationDetailRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private AuditFeeValidationInfoService auditFeeValidationInfoService;
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;

    public String getCacheKeyPrefix() {
        return "audit_fee:validation_detail_cache:";
    }

    public Class<AuditFeeValidationDetailDto> getDtoClass() {
        return AuditFeeValidationDetailDto.class;
    }

    public Class<AuditFeeValidationDetailVo> getVoClass() {
        return AuditFeeValidationDetailVo.class;
    }

    public List<AuditFeeValidationDetailDto> findDtoListFromRepository(AuditFeeValidationDetailDto dto, String cacheKey) {
        if (!StringUtils.hasText((String)dto.getAuditCode())) {
            return Lists.newArrayList();
        }
        Assert.hasText((String)cacheKey, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a");
        List<AuditFeeValidationDetailEntity> entities = this.auditFeeValidationDetailRepository.findByAuditCode(dto.getAuditCode());
        List detailDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, AuditFeeValidationDetailEntity.class, AuditFeeValidationDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        String auditCode = dto.getAuditCode();
        List<AuditFeeValidationInfoVo> auditFeeValidationInfoVos = this.auditFeeValidationInfoService.findByAuditCode(auditCode);
        this.auditFeeValidationInfoService.saveAuditInfoCache(cacheKey, auditFeeValidationInfoVos);
        return detailDtos;
    }

    public boolean initToCacheFromRepository() {
        return true;
    }

    public void filterSaveItem(String cacheKey, List<Object> idList, List<AuditFeeValidationDetailDto> itemList, List<AuditFeeValidationDetailDto> updateList) {
        if (CollectionUtils.isEmpty(idList) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cacheKey)) {
            return;
        }
        itemList.stream().distinct();
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        Set idKeys = this.redisTemplate.keys((Object)(redisCacheIdKey + "*"));
        ArrayList dataList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)idKeys)) {
            for (String idKey : idKeys) {
                String dataKey = idKey.replace("id:", "data:");
                dataList.addAll(this.redisTemplate.opsForHash().multiGet((Object)dataKey, idList));
            }
        }
        log.info("\u5dee\u5f02\u7ed3\u6848\u7f13\u5b58dataList:{}", (Object)dataList.size());
        List detailCodes = dataList.stream().map(AuditFeeValidationDetailDto::getDetailCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailCodes)) {
            return;
        }
        log.info("\u5dee\u5f02\u7ed3\u6848\u7f13\u5b58detailCodes:{}", (Object)JSON.toJSONString(detailCodes));
        log.info("\u5dee\u5f02\u7ed3\u6848\u7f13\u5b58itemList:{}", (Object)itemList.size());
        if (!CollectionUtils.isEmpty(itemList)) {
            itemList.removeIf(f -> detailCodes.contains(f.getDetailCode()));
        }
        log.info("\u5dee\u5f02\u7ed3\u6848\u7f13\u5b58itemList:{}", (Object)itemList.size());
    }

    public List<AuditFeeValidationDetailDto> newItem(String cacheKey, List<AuditFeeValidationDetailDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Lists.newArrayList();
        }
        ArrayList newItemDtoList = Lists.newArrayList();
        Map<String, List<AuditFeeValidationDetailDto>> itemMap = itemList.stream().collect(Collectors.groupingBy(AuditFeeValidationDetailDto::getDetailCode));
        for (Map.Entry<String, List<AuditFeeValidationDetailDto>> entry : itemMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            if (entry.getValue().size() >= 2) {
                newItemDtoList.add(entry.getValue().get(0));
                continue;
            }
            newItemDtoList.addAll((Collection)entry.getValue());
        }
        Set detailCodes = newItemDtoList.stream().map(AuditFeeValidationDetailDto::getDetailCode).collect(Collectors.toSet());
        List detailedForecastVos = this.detailedForecastService.findByActivityDetailItemCode(detailCodes);
        Map detailedForecastVoMap = detailedForecastVos.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, Function.identity(), (v1, v2) -> v2));
        newItemDtoList.forEach(newItem -> {
            DetailedForecastVo detailedForecastVo;
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setApplyAmount(newItem.getFeeAmount());
            newItem.setWholeAudit(BooleanEnum.TRUE.getCapital());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)newItem.getAuditDetailCode()) && !newItem.getAuditDetailCode().startsWith("AFDVD")) {
                newItem.setAuditDetailCode(null);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)newItem.getDetailCode()) && !CollectionUtils.isEmpty((Map)detailedForecastVoMap) && !Objects.isNull(detailedForecastVo = (DetailedForecastVo)detailedForecastVoMap.get(newItem.getDetailCode()))) {
                newItem.setAuditAmount(detailedForecastVo.getEstimatedWriteOffAmount());
            }
        });
        return newItemDtoList;
    }

    public void updateItem(String cacheKey, List<AuditFeeValidationDetailDto> itemList) {
    }

    public List<AuditFeeValidationDetailDto> copyItem(String cacheKey, List<AuditFeeValidationDetailDto> itemList) {
        List newList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, AuditFeeValidationDetailDto.class, AuditFeeValidationDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (AuditFeeValidationDetailDto newItem : newList) {
            newItem.setId(UuidCrmUtil.general());
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTenantCode(TenantUtils.getTenantCode());
        }
        return newList;
    }

    public Object getDtoKey(AuditFeeValidationDetailDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(AuditFeeValidationDetailDto dto) {
        return dto.getChecked();
    }
}

