/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.controller;

import cn.hutool.core.lang.Snowflake;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationInfoService;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auditFeeValidation/validation"})
@Api(tags={"\u4e1a\u52a1\u6a21\u5757: auditFeeValidation: \u5546\u8d85\u8d39\u7528\u7ed3\u6848\u6838\u9500\u4e3b\u8868"})
public class AuditFeeValidationController {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeValidationController.class);
    @Autowired(required=false)
    private AuditFeeValidationService auditFeeValidationService;
    @Autowired(required=false)
    private AuditFeeValidationInfoService auditFeeValidationInfoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u589e\u7f16\u8f91")
    @PostMapping(value={""})
    public Result<?> createOrUpdate(@RequestBody AuditFeeValidationDto dto) {
        String redisKey;
        Result result;
        String currentOperateId;
        block9: {
            String lockKey = "audit_fee:edit:" + dto.getId();
            boolean locked = false;
            currentOperateId = new Snowflake().nextIdStr();
            try {
                if (StringUtils.isNotEmpty((CharSequence)dto.getId())) {
                    locked = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 30L, 1L);
                    Validate.isTrue((boolean)locked, (String)"\u6570\u636e\u6b63\u5728\u7f16\u8f91\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
                }
                dto.setCurrentOperateId(currentOperateId);
                this.auditFeeValidationService.createOrUpdate(dto);
                result = Result.ok();
                if (!locked) break block9;
            }
            catch (RuntimeException e) {
                String redisKey2;
                Result result2;
                block10: {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                        result2 = Result.error((String)e.getMessage());
                        if (!locked) break block10;
                    }
                    catch (Throwable throwable) {
                        String redisKey3;
                        if (locked) {
                            this.redisLockService.unlock(lockKey);
                        }
                        if (this.redisService.hasKey(redisKey3 = String.format("audit_fee_validation:code:%s", currentOperateId)).booleanValue()) {
                            List obj = (List)this.redisService.get(redisKey3);
                            this.auditFeeDiffLedgerLockService.unlock(obj);
                            this.redisService.del(redisKey3);
                        }
                        throw throwable;
                    }
                    this.redisLockService.unlock(lockKey);
                }
                if (this.redisService.hasKey(redisKey2 = String.format("audit_fee_validation:code:%s", currentOperateId)).booleanValue()) {
                    List obj = (List)this.redisService.get(redisKey2);
                    this.auditFeeDiffLedgerLockService.unlock(obj);
                    this.redisService.del(redisKey2);
                }
                return result2;
            }
            this.redisLockService.unlock(lockKey);
        }
        if (this.redisService.hasKey(redisKey = String.format("audit_fee_validation:code:%s", currentOperateId)).booleanValue()) {
            List obj = (List)this.redisService.get(redisKey);
            this.auditFeeDiffLedgerLockService.unlock(obj);
            this.redisService.del(redisKey);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"submitApproval"})
    public Result<?> submitApproval(@RequestBody AuditFeeValidationDto dto) {
        String redisKey;
        Result result;
        String currentOperateId;
        block8: {
            String lockKey = "audit_fee:submit_approval" + dto.getAuditCode();
            boolean locked = false;
            currentOperateId = new Snowflake().nextIdStr();
            try {
                locked = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 30L, 1L);
                Validate.isTrue((boolean)locked, (String)"\u6b63\u5728\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e", (Object[])new Object[0]);
                dto.setCurrentOperateId(currentOperateId);
                this.auditFeeValidationService.submitApproval(dto);
                result = Result.ok();
                if (!locked) break block8;
            }
            catch (RuntimeException e) {
                String redisKey2;
                Result result2;
                block9: {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                        result2 = Result.error((String)e.getMessage());
                        if (!locked) break block9;
                    }
                    catch (Throwable throwable) {
                        String redisKey3;
                        if (locked) {
                            this.redisLockService.unlock(lockKey);
                        }
                        if (this.redisService.hasKey(redisKey3 = String.format("audit_fee_validation:code:%s", currentOperateId)).booleanValue()) {
                            List obj = (List)this.redisService.get(redisKey3);
                            this.auditFeeDiffLedgerLockService.unlock(obj);
                            this.redisService.del(redisKey3);
                        }
                        throw throwable;
                    }
                    this.redisLockService.unlock(lockKey);
                }
                if (this.redisService.hasKey(redisKey2 = String.format("audit_fee_validation:code:%s", currentOperateId)).booleanValue()) {
                    List obj = (List)this.redisService.get(redisKey2);
                    this.auditFeeDiffLedgerLockService.unlock(obj);
                    this.redisService.del(redisKey2);
                }
                return result2;
            }
            this.redisLockService.unlock(lockKey);
        }
        if (this.redisService.hasKey(redisKey = String.format("audit_fee_validation:code:%s", currentOperateId)).booleanValue()) {
            List obj = (List)this.redisService.get(redisKey);
            this.auditFeeDiffLedgerLockService.unlock(obj);
            this.redisService.del(redisKey);
        }
        return result;
    }

    @ApiOperation(value="\u6279\u91cf\u5173\u8054")
    @GetMapping(value={"batchRelevance"})
    public Result<?> batchRelevance(AuditFeeDiffTrackDetailDto dto) {
        try {
            Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            this.auditFeeValidationService.batchRelevance(loginUser, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.auditFeeValidationService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enableBatch(@RequestBody List<String> ids) {
        try {
            this.auditFeeValidationService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disableBatch(@RequestBody List<String> ids) {
        try {
            this.auditFeeValidationService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u6838\u9500\u8d44\u6599\u5230\u7f13\u5b58\u4e2d")
    @PostMapping(value={"saveAuditInfoCache"})
    public Result<?> saveAuditInfoCache(@RequestBody AuditFeeValidationDto dto) {
        try {
            this.auditFeeValidationInfoService.saveAuditInfoCache(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

