/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationDetailVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateExportVo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import liquibase.util.Validate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeValidationDetailUpdateExportsProcess
implements ExportProcess<AuditFeeValidationDetailUpdateExportVo> {
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private AuditFeeValidationDetailVoService auditFeeValidationDetailVoService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_MAX_TOTAL;
    }

    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        Integer total = this.auditFeeValidationDetailVoService.getExportTotal(cacheKey);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6,\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"));
        return total;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58\u53ef\u4ee5\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        List result = this.auditFeeValidationDetailVoService.getExportData(cacheKey);
        for (AuditFeeValidationDetailUpdateExportVo auditFeeValidationDetailUpdateExportVo : result) {
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)result));
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public Class<AuditFeeValidationDetailUpdateExportVo> findCrmExcelVoClass() {
        return AuditFeeValidationDetailUpdateExportVo.class;
    }

    public String getBusinessCode() {
        return "audit_fee_validation_detail_export";
    }

    public String getBusinessName() {
        return "\u5dee\u5f02\u7ed3\u6848\u660e\u7ec6\u5bfc\u51fa\u7f16\u8f91";
    }
}

