/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.helper;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.enums.SaveTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeValidationHelper {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeValidationHelper.class);
    @Resource
    private GenerateCodeService generateCodeService;
    @Value(value="${spring.application.name:}")
    private String applicationName;
    @Autowired(required=false)
    private ChannelMsgService channelMsgService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public String generateCode() {
        return (String)this.generateCodeService.generateCode("AFDV", 1).get(0);
    }

    public List<String> generateDetailCodes(Integer number) {
        return this.generateCodeService.generateCode("AFDVD", number.intValue());
    }

    public void verifyParams(AuditFeeValidationDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (YesOrNoEnum.YES.getCode().equals(dto.getIsEdit())) {
            Validate.notBlank((CharSequence)dto.getId(), (String)"\u7f16\u8f91id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (SaveTypeEnum.SAVE.getCode().equals(dto.getSaveType()) || SaveTypeEnum.SUBMIT.getCode().equals(dto.getSaveType())) {
            // empty if block
        }
    }

    public void verifyDetails(String saveType, List<AuditFeeValidationDetailDto> detailDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(detailDtos) ? 1 : 0) != 0, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (SaveTypeEnum.SAVE.getCode().equals(saveType) || SaveTypeEnum.SUBMIT.getCode().equals(saveType)) {
            detailDtos.forEach(detail -> {
                Validate.notNull((Object)detail.getThisAuditAmount(), (String)"\u672c\u6b21\u7ed3\u6848\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)detail.getWholeAudit(), (String)"\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            });
        }
        Map<String, List<AuditFeeValidationDetailDto>> detailDtoMap = detailDtos.stream().collect(Collectors.groupingBy(AuditFeeValidationDetailDto::getDetailCode));
        for (String key : detailDtoMap.keySet()) {
            List<AuditFeeValidationDetailDto> detaiList = detailDtoMap.get(key);
            if (CollectionUtils.isEmpty(detaiList) || detaiList.size() < 2) continue;
            throw new IllegalArgumentException("\u5f53\u524d\u660e\u7ec6\u884c\u4e2d\uff0c\u8ffd\u8e2a\u660e\u7ec6\u3010" + detaiList.get(0).getDetailCode() + "\u3011\u91cd\u590d\u9009\u62e9\u4e86");
        }
    }

    public void sendMsg(String remark) {
        this.sendMsg(remark, ExecStatusEnum.RUNNING.getKey());
    }

    public void sendMsg(String remark, String execStatus) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("remark", (Object)remark);
        String time = DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        jsonObject.put("time", (Object)time);
        jsonObject.put("applicationName", (Object)this.applicationName);
        jsonObject.put("execStatus", (Object)execStatus);
        byte[] jsonBytes = JSONObject.toJSONBytes((Object)jsonObject, (SerializerFeature[])new SerializerFeature[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String modelCode = "audit_fee_batch_relevance";
        log.info(" \u6279\u91cf\u5173\u8054 model send msg: tenantCode = {} , applicationName = {} , modelCode = {} ,remark = {}", new Object[]{tenantCode, this.applicationName, modelCode, remark});
        UserIdentity loginUser = this.loginUserService.getLoginUser();
        this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, this.applicationName, modelCode, loginUser.getAccount(), jsonBytes);
    }
}

