/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.imports;

import cn.hutool.json.JSONUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationDetailVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateImportVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.util.Validate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeValidationDetailUpdateImportsProcess
implements ImportProcess<AuditFeeValidationDetailUpdateImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeValidationDetailUpdateImportsProcess.class);
    @Autowired(required=false)
    private AuditFeeValidationDetailVoService auditFeeValidationDetailVoService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditFeeValidationDetailUpdateImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.info("\u5bfc\u5165\u53c2\u6570++++++:[{}],[{}]", params, (Object)JSONUtil.toJsonStr(data.values()));
        String cacheKey = this.getCacheKey(params);
        HashMap errorMap = Maps.newHashMap();
        try {
            if (data.values().isEmpty()) {
                throw new IllegalArgumentException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
            }
            ArrayList importsVoList = Lists.newArrayList(data.values());
            List result = this.auditFeeValidationDetailVoService.validate((List)importsVoList, cacheKey, (Map)errorMap);
            if (0 == errorMap.size()) {
                log.info("\u9a8c\u8bc1\u6210\u529f\u6570\u636e: {}", (Object)JSONUtil.toJsonStr((Object)result));
                this.auditFeeValidationDetailVoService.imports(cacheKey, result);
            }
        }
        catch (Exception e) {
            log.error("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5bfc\u5165\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        HashMap<Integer, String> resultErrorMap = new HashMap<Integer, String>();
        data.forEach((key, value) -> {
            String msg = (String)errorMap.get(value.getId());
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                msg = "\u7b2c" + (key + 1) + "\u884c" + msg;
                resultErrorMap.put((Integer)key, msg);
            }
        });
        return resultErrorMap;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    public Class<AuditFeeValidationDetailUpdateImportVo> findCrmExcelVoClass() {
        return AuditFeeValidationDetailUpdateImportVo.class;
    }

    public String getTemplateCode() {
        return "audit_fee_validation_detail_update_import";
    }

    public String getTemplateName() {
        return "\u5dee\u5f02\u7ed3\u6848\u660e\u7ec6\u5bfc\u5165\u7f16\u8f91";
    }
}

