/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.register;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailLedgerVo;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationDetailUseLedgerService;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUseLedgerVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeValidationListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeValidationListener.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;
    @Autowired(required=false)
    private AuditFeeValidationService auditFeeValidationService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;
    @Autowired(required=false)
    private AuditFeeValidationDetailUseLedgerService auditFeeValidationDetailUseLedgerService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Transactional(rollbackFor={Exception.class})
    public void onProcessComplete(ProcessStatusDto dto) {
        String currentOperateId;
        block12: {
            AuditFeeValidationVo auditHandles;
            block11: {
                log.info("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03\uff0c\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
                String auditCode = dto.getBusinessNo();
                Validate.notEmpty((CharSequence)auditCode, (String)"\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6210\u529f\u56de\u8c03,\u63d0\u4ea4\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
                auditHandles = this.auditFeeValidationService.findConditionByAuditCode(auditCode);
                Validate.notNull((Object)auditHandles, (String)"\u6839\u636e\u4e1a\u52a1\u7f16\u7801\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u6570\u636e\uff01", (Object[])new Object[0]);
                currentOperateId = new Snowflake().nextIdStr();
                log.info("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03\u66f4\u65b0\u72b6\u6001");
                this.auditFeeValidationService.updateProcessStatusByAuditCode(auditHandles.getAuditCode(), ProcessStatusEnum.getStatusEnumByDictCode((String)dto.getProcessStatus()), dto.getProcessNo());
                if (!CollectionUtils.isEmpty((Collection)auditHandles.getDetailList())) break block11;
                log.info("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03auditCode:{},\u660e\u7ec6\u4e3a\u7a7a");
                log.info("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03\u89e3\u9501");
                String redisKey = String.format("audit_fee_validation:code:%s", currentOperateId);
                if (this.redisService.hasKey(redisKey).booleanValue()) {
                    List obj = (List)this.redisService.get(redisKey);
                    this.auditFeeDiffLedgerLockService.unlock(obj);
                    this.redisService.del(redisKey);
                }
                return;
            }
            try {
                if (StringUtils.equals((CharSequence)dto.getProcessStatus(), (CharSequence)ProcessStatusEnum.PASS.getDictCode())) {
                    this.operateAmount(currentOperateId, dto.getProcessStatus(), auditHandles.getDetailList());
                } else if (StringUtils.equals((CharSequence)dto.getProcessStatus(), (CharSequence)ProcessStatusEnum.REJECT.getDictCode()) || StringUtils.equals((CharSequence)dto.getProcessStatus(), (CharSequence)ProcessStatusEnum.RECOVER.getDictCode())) {
                    this.operateAmount(currentOperateId, dto.getProcessStatus(), auditHandles.getDetailList());
                }
                if (!StringUtils.equals((CharSequence)dto.getProcessStatus(), (CharSequence)ProcessStatusEnum.PASS.getDictCode())) break block12;
                ArrayList updateList = new ArrayList();
                auditHandles.getDetailList().forEach(detail -> {
                    AuditFeeDiffTrackDetailDto trackDetailDto = new AuditFeeDiffTrackDetailDto();
                    trackDetailDto.setPlanCode(detail.getPlanCode());
                    trackDetailDto.setDetailCode(detail.getDetailCode());
                    trackDetailDto.setAlreadyAuditAmount(detail.getThisAuditAmount());
                    trackDetailDto.setWholeAudit(detail.getWholeAudit());
                    updateList.add(trackDetailDto);
                });
                this.auditFeeDiffTrackDetailVoService.updateAlreadyAuditAmountByValidationPass(updateList);
            }
            catch (Exception e) {
                try {
                    log.error("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03\u5931\u8d25");
                    throw e;
                }
                catch (Throwable throwable) {
                    log.info("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03\u89e3\u9501");
                    String redisKey = String.format("audit_fee_validation:code:%s", currentOperateId);
                    if (this.redisService.hasKey(redisKey).booleanValue()) {
                        List obj = (List)this.redisService.get(redisKey);
                        this.auditFeeDiffLedgerLockService.unlock(obj);
                        this.redisService.del(redisKey);
                    }
                    throw throwable;
                }
            }
        }
        log.info("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03\u89e3\u9501");
        String redisKey = String.format("audit_fee_validation:code:%s", currentOperateId);
        if (this.redisService.hasKey(redisKey).booleanValue()) {
            List obj = (List)this.redisService.get(redisKey);
            this.auditFeeDiffLedgerLockService.unlock(obj);
            this.redisService.del(redisKey);
        }
    }

    public String getBusinessCode() {
        return "tpm_audit_fee_process";
    }

    private void operateAmount(String currentOperateId, String processStatus, List<AuditFeeValidationDetailVo> details) {
        List<String> auditDetailCodes;
        List<AuditFeeValidationDetailUseLedgerVo> useLedgerVoList;
        List detailCodes;
        log.info("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03\u5904\u7406\u9700\u8981\u6263\u51cf\u7684\u660e\u7ec6\u884c");
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        Map<Object, Object> ledgerVoMap = new HashMap();
        HashMap diffLedgerVoMap = new HashMap();
        Map<Object, Object> useLegerVoListMap = new HashMap();
        ArrayList<String> useLedgerIdList = new ArrayList<String>();
        if (StringUtils.equals((CharSequence)processStatus, (CharSequence)ProcessStatusEnum.PASS.getDictCode()) && !CollectionUtils.isEmpty(detailCodes = details.stream().filter(f -> BooleanEnum.TRUE.getCapital().equals(f.getWholeAudit())).map(AuditFeeValidationDetailVo::getDetailCode).distinct().collect(Collectors.toList()))) {
            List ledgers = this.auditFeeDiffTrackDetailVoService.findLedgerByDetailCodes(detailCodes);
            Validate.notEmpty((Collection)ledgers, (String)"\u672a\u67e5\u8be2\u5230\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u76f8\u5173\u8054\u7684\u5dee\u5f02\u8d39\u7528\u53f0\u8d26!", (Object[])new Object[0]);
            ledgerVoMap = ledgers.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailLedgerVo::getDetailCode));
        }
        if ((StringUtils.equals((CharSequence)processStatus, (CharSequence)ProcessStatusEnum.REJECT.getDictCode()) || StringUtils.equals((CharSequence)processStatus, (CharSequence)ProcessStatusEnum.RECOVER.getDictCode())) && !CollectionUtils.isEmpty(useLedgerVoList = this.auditFeeValidationDetailUseLedgerService.findByAuditDetailCodes(auditDetailCodes = details.stream().map(AuditFeeValidationDetailVo::getAuditDetailCode).distinct().collect(Collectors.toList())))) {
            useLegerVoListMap = useLedgerVoList.stream().collect(Collectors.groupingBy(AuditFeeValidationDetailUseLedgerVo::getAuditDetailCode));
        }
        ArrayList operateDto = Lists.newArrayList();
        for (AuditFeeValidationDetailVo detail : details) {
            BigDecimal amount;
            if (StringUtils.equals((CharSequence)processStatus, (CharSequence)ProcessStatusEnum.PASS.getDictCode()) && BooleanEnum.TRUE.getCapital().equals(detail.getWholeAudit()) && (amount = ((BigDecimal)ObjectUtils.defaultIfNull((Object)detail.getAlreadyAuditAmount(), (Object)BigDecimal.ZERO)).add(detail.getThisAuditAmount())).compareTo(detail.getApplyAmount()) < 0) {
                if (CollectionUtils.isEmpty(ledgerVoMap) || CollectionUtils.isEmpty((Collection)((Collection)ledgerVoMap.get(detail.getDetailCode())))) {
                    throw new RuntimeException("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u3010" + detail.getDetailCode() + "\u3011,\u6ca1\u6709\u5173\u8054\u7684\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\uff0c\u65e0\u6cd5\u56de\u9000\u91d1\u989d");
                }
                BigDecimal returnAmountTotal = detail.getApplyAmount().subtract(amount);
                List detailLedgerVoList = (List)ledgerVoMap.get(detail.getDetailCode());
                detailLedgerVoList.stream().sorted(Comparator.comparing(AuditFeeDiffTrackDetailLedgerVo::getFeeDiffLedgerCode).reversed()).collect(Collectors.toList());
                for (AuditFeeDiffTrackDetailLedgerVo auditFeeDiffTrackDetailLedgerVo : detailLedgerVoList) {
                    if (returnAmountTotal.compareTo(BigDecimal.ZERO) == 0) break;
                    BigDecimal usedAmount = Optional.ofNullable(auditFeeDiffTrackDetailLedgerVo.getUsedAmount()).orElse(BigDecimal.ZERO);
                    if (usedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    AuditFeeDiffLedgerDeductionDto dto = new AuditFeeDiffLedgerDeductionDto();
                    dto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode());
                    dto.setFeeDiffLedgerCode(auditFeeDiffTrackDetailLedgerVo.getFeeDiffLedgerCode());
                    dto.setDataSource(DiffLedgerDataSourceEnum.DIFF_CLOSED.getCode());
                    dto.setBusinessCode(detail.getAuditDetailCode());
                    dto.setFeeDiffLedgerDisposeCode(detail.getDetailCode());
                    dto.setActivityFormCode(detail.getActivityFormCode());
                    dto.setActivityFormName(detail.getActivityFormName());
                    dto.setActivityTypeCode(detail.getActivityTypeCode());
                    dto.setActivityTypeName(detail.getActivityTypeName());
                    dto.setResaleCommercialCode(detail.getSystemCode());
                    dto.setResaleCommercialName(detail.getSystemName());
                    dto.setTerminalCode(detail.getTerminalCode());
                    dto.setTerminalName(detail.getTerminalName());
                    if (!Objects.isNull(loginUserDetails)) {
                        dto.setOperatorAccount(loginUserDetails.getAccount());
                    }
                    if (returnAmountTotal.compareTo(usedAmount) > 0) {
                        dto.setRecoveredAmount(usedAmount);
                        returnAmountTotal = returnAmountTotal.subtract(usedAmount);
                    } else {
                        dto.setRecoveredAmount(returnAmountTotal);
                        returnAmountTotal = BigDecimal.ZERO;
                    }
                    operateDto.add(dto);
                }
            }
            if (!StringUtils.equals((CharSequence)processStatus, (CharSequence)ProcessStatusEnum.REJECT.getDictCode()) && !StringUtils.equals((CharSequence)processStatus, (CharSequence)ProcessStatusEnum.RECOVER.getDictCode()) || (amount = ((BigDecimal)ObjectUtils.defaultIfNull((Object)detail.getAlreadyAuditAmount(), (Object)BigDecimal.ZERO)).add(detail.getThisAuditAmount())).compareTo(detail.getApplyAmount()) <= 0 || CollectionUtils.isEmpty(useLegerVoListMap) || CollectionUtils.isEmpty((Collection)((Collection)useLegerVoListMap.get(detail.getAuditDetailCode())))) continue;
            List auditFeeValidationDetailUseLedgerVos = (List)useLegerVoListMap.get(detail.getAuditDetailCode());
            for (AuditFeeValidationDetailUseLedgerVo useLedgerVo : auditFeeValidationDetailUseLedgerVos) {
                AuditFeeDiffLedgerDeductionDto dto = new AuditFeeDiffLedgerDeductionDto();
                dto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode());
                dto.setRecoveredAmount(useLedgerVo.getRecoveredAmount());
                dto.setFeeDiffLedgerCode(useLedgerVo.getFeeDiffLedgerCode());
                dto.setDataSource(DiffLedgerDataSourceEnum.DIFF_CLOSED.getCode());
                dto.setBusinessCode(detail.getAuditDetailCode());
                dto.setFeeDiffLedgerDisposeCode(detail.getDetailCode());
                dto.setActivityFormCode(detail.getActivityFormCode());
                dto.setActivityFormName(detail.getActivityFormName());
                dto.setActivityTypeCode(detail.getActivityTypeCode());
                dto.setActivityTypeName(detail.getActivityTypeName());
                dto.setResaleCommercialCode(detail.getSystemCode());
                dto.setResaleCommercialName(detail.getSystemName());
                dto.setTerminalCode(detail.getTerminalCode());
                dto.setTerminalName(detail.getTerminalName());
                if (!Objects.isNull(loginUserDetails)) {
                    dto.setOperatorAccount(loginUserDetails.getAccount());
                }
                operateDto.add(dto);
                useLedgerIdList.add(useLedgerVo.getId());
            }
        }
        if (CollectionUtils.isEmpty((Collection)operateDto)) {
            return;
        }
        log.info("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03\u5f00\u59cb\u8fdb\u884c\u6263\u51cf\u660e\u7ec6");
        this.auditFeeValidationService.operateAmount(currentOperateId, operateDto);
        if (!CollectionUtils.isEmpty(useLedgerIdList)) {
            log.info("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848\u5ba1\u6279\u6d41\u56de\u8c03\u5f00\u59cb\u66f4\u65b0\u62b5\u6263\u8bb0\u5f55\u7684\u56de\u9000\u6807\u8bb0");
            this.auditFeeValidationDetailUseLedgerService.updateIsReturned(useLedgerIdList, BooleanEnum.TRUE.getCapital());
        }
    }
}

