/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.mapper.AuditFeeValidationMapper;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeValidationRepository
extends ServiceImpl<AuditFeeValidationMapper, AuditFeeValidationEntity> {
    public Page<AuditFeeValidationVo> findByConditions(Pageable pageable, AuditFeeValidationDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return ((AuditFeeValidationMapper)this.baseMapper).findByConditions((Page<AuditFeeValidationVo>)page, dto);
    }

    public AuditFeeValidationVo findOne(AuditFeeValidationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return ((AuditFeeValidationMapper)this.baseMapper).findOne(dto);
    }

    public List<AuditFeeValidationVo> findListVo(AuditFeeValidationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return ((AuditFeeValidationMapper)this.baseMapper).findListVo(dto);
    }

    public void deleteBatch(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void enableBatch(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).update();
    }

    public void disableBatch(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).update();
    }

    public void updateProcessStatusByAuditCode(String auditCode, ProcessStatusEnum commit, String processNo) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditFeeValidationEntity::getAuditCode, (Object)auditCode)).set(StringUtils.isNotEmpty((CharSequence)processNo), AuditFeeValidationEntity::getProcessNo, (Object)processNo).set(StringUtils.isNotEmpty((CharSequence)commit.getDictCode()), AuditFeeValidationEntity::getProcessStatus, (Object)commit.getDictCode()).set(AuditFeeValidationEntity::getProcessDate, (Object)new Date())).update();
    }

    public AuditFeeValidationEntity findByAuditCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return null;
        }
        AuditFeeValidationEntity one = (AuditFeeValidationEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditFeeValidationEntity::getAuditCode, (Object)auditCode)).one());
        return one;
    }

    public List<String> findProcessStatusNotPass(List<String> detailCodeList) {
        if (CollectionUtils.isEmpty(detailCodeList)) {
            return Collections.emptyList();
        }
        return ((AuditFeeValidationMapper)this.baseMapper).findProcessStatusNotPass(detailCodeList);
    }
}

