/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationDetailEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.helper.AuditFeeValidationHelper;
import com.biz.crm.tpm.business.audit.fee.validation.local.repository.AuditFeeValidationDetailRepository;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationDetailService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationDetailVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="auditFeeValidationDetailService")
public class AuditFeeValidationDetailServiceImpl
implements AuditFeeValidationDetailService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeValidationDetailServiceImpl.class);
    @Resource
    private AuditFeeValidationDetailVoService auditFeeValidationDetailVoService;
    @Resource
    private AuditFeeValidationDetailRepository auditFeeValidationDetailRepository;
    @Resource
    private AuditFeeValidationHelper auditFeeValidationHelper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;

    @Override
    public List<AuditFeeValidationDetailDto> createOrUpdate(String auditCode, boolean isEdit, String cacheKey, String saveType) {
        List<AuditFeeValidationDetailEntity> detailEntityList;
        Map<Object, Object> detailOldMap = new HashMap();
        List detailDtos = this.auditFeeValidationDetailVoService.findCacheList(cacheKey);
        this.auditFeeValidationHelper.verifyDetails(saveType, detailDtos);
        List detailCodes = detailDtos.stream().map(AuditFeeValidationDetailDto::getDetailCode).distinct().collect(Collectors.toList());
        List endCastCodes = this.auditFeeDiffTrackDetailVoService.findEndCastFormByDetailCodes(detailCodes);
        if (!CollectionUtils.isEmpty((Collection)endCastCodes)) {
            StringBuilder errMsg = new StringBuilder();
            if (endCastCodes.size() > 5) {
                endCastCodes.forEach(e -> errMsg.append(e + ";"));
            }
            throw new RuntimeException("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u5df2\u5b8c\u5168\u7ed3\u6848,\u4e0d\u53ef\u518d\u6b21\u7ed3\u6848\u3002\u5b8c\u5168\u7ed3\u6848\u8ffd\u8e2a\u660e\u7ec6\u7f16\u7801\u3010" + (endCastCodes.size() > 5 ? JSONObject.toJSONString((Object)endCastCodes) : errMsg.toString()) + "\u3011");
        }
        if (isEdit && !CollectionUtils.isEmpty(detailEntityList = this.auditFeeValidationDetailRepository.findByAuditCode(auditCode))) {
            Collection detailDtos2 = this.nebulaToolkitService.copyCollectionByWhiteList(detailEntityList, AuditFeeValidationDetailEntity.class, AuditFeeValidationDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            detailOldMap = detailDtos2.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        }
        ArrayList<AuditFeeValidationDetailDto> addData = new ArrayList<AuditFeeValidationDetailDto>();
        ArrayList<AuditFeeValidationDetailDto> updateDate = new ArrayList<AuditFeeValidationDetailDto>();
        for (AuditFeeValidationDetailDto o : detailDtos) {
            o.setAuditCode(auditCode);
            o.setTenantCode(TenantUtils.getTenantCode());
            AuditFeeValidationDetailDto dto = (AuditFeeValidationDetailDto)detailOldMap.get(o.getId());
            if (dto == null) {
                addData.add(o);
                continue;
            }
            updateDate.add(o);
            detailOldMap.remove(o.getId());
        }
        if (!CollectionUtils.isEmpty(addData)) {
            List<String> codes = this.auditFeeValidationHelper.generateDetailCodes(addData.size());
            AtomicInteger index = new AtomicInteger(0);
            addData.forEach(item -> item.setAuditDetailCode((String)codes.get(index.getAndIncrement())));
            List addDataEntitys = (List)this.nebulaToolkitService.copyCollectionByWhiteList(addData, AuditFeeValidationDetailDto.class, AuditFeeValidationDetailEntity.class, HashSet.class, ArrayList.class, new String[0]);
            this.auditFeeValidationDetailRepository.saveBatch(addDataEntitys);
        }
        if (!CollectionUtils.isEmpty(updateDate)) {
            List updateDateEntitys = (List)this.nebulaToolkitService.copyCollectionByWhiteList(updateDate, AuditFeeValidationDetailDto.class, AuditFeeValidationDetailEntity.class, HashSet.class, ArrayList.class, new String[0]);
            this.auditFeeValidationDetailRepository.updateBatchById(updateDateEntitys);
        }
        if (!CollectionUtils.isEmpty(detailOldMap)) {
            this.auditFeeValidationDetailRepository.removeByIds(detailOldMap.keySet());
        }
        return detailDtos;
    }

    @Override
    public void addItemCache(String cacheKey, List<AuditFeeValidationDetailDto> detailDtos) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(detailDtos) ? 1 : 0) != 0, (String)"\u8981\u7f13\u5b58\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditFeeValidationDetailVoService.addItemCache(cacheKey, detailDtos);
    }

    @Override
    public List<AuditFeeValidationDetailEntity> findByAuditCode(String auditCode) {
        return this.auditFeeValidationDetailRepository.findByAuditCode(auditCode);
    }

    @Override
    public List<AuditFeeValidationDetailDto> findInApprovalValidation(String id, String auditCode, List<String> detailCodes, String processStatus) {
        if (StringUtils.isBlank((CharSequence)auditCode) && CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeValidationDetailDto> list = new ArrayList<AuditFeeValidationDetailDto>();
        if (!StringUtils.isBlank((CharSequence)auditCode)) {
            list = this.auditFeeValidationDetailRepository.findInApprovalValidation(id, auditCode, processStatus, TenantUtils.getTenantCode());
        }
        if (!CollectionUtils.isEmpty(detailCodes)) {
            list = this.auditFeeValidationDetailRepository.findInApprovalValidation(id, detailCodes, processStatus, TenantUtils.getTenantCode());
        }
        return list;
    }
}

