/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.service.internal;

import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationDetailVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateExportVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateImportVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="auditFeeValidationDetailVoService")
public class AuditFeeValidationDetailVoServiceImpl
extends MnPageCacheServiceImpl<AuditFeeValidationDetailVo, AuditFeeValidationDetailDto>
implements AuditFeeValidationDetailVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeValidationDetailVoServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public Integer getExportTotal(String cacheKey) {
        return this.findCacheList(cacheKey).size();
    }

    public List<AuditFeeValidationDetailUpdateExportVo> getExportData(String cacheKey) {
        List dtoList = this.findCacheList(cacheKey);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dtoList, AuditFeeValidationDetailDto.class, AuditFeeValidationDetailUpdateExportVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditFeeValidationDetailDto> validate(List<AuditFeeValidationDetailUpdateImportVo> importsVoList, String cacheKey, Map<String, String> errorMap) {
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        ArrayList dataList = Lists.newArrayList();
        HashSet yesNo = Sets.newHashSet((Object[])new String[]{"\u662f", "\u5426"});
        importsVoList.forEach(e -> {
            Object obj = this.redisTemplate.opsForHash().get((Object)redisCacheDataKey, (Object)e.getId());
            if (Objects.isNull(obj)) {
                return;
            }
            AuditFeeValidationDetailDto data = (AuditFeeValidationDetailDto)obj;
            StringBuffer sb = new StringBuffer();
            String thisAuditAmountStr = e.getThisAuditAmountStr();
            String wholeAudit = e.getWholeAudit();
            if (StringUtils.isBlank((CharSequence)thisAuditAmountStr)) {
                sb.append("\u672c\u6b21\u7ed3\u6848\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                try {
                    data.setThisAuditAmount(new BigDecimal(thisAuditAmountStr));
                }
                catch (Exception ex) {
                    sb.append("\u672c\u6b21\u7ed3\u6848\u91d1\u989d\u4e0d\u662f\u6570\u5b57;");
                }
            }
            if (StringUtils.isBlank((CharSequence)wholeAudit)) {
                sb.append("\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!yesNo.contains(wholeAudit)) {
                sb.append("\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u586b\u5199\u9519\u8bef;");
            } else {
                data.setWholeAudit("\u662f".equals(wholeAudit) ? "1" : "0");
            }
            if (sb.length() > 0) {
                errorMap.put(e.getId(), sb.toString());
            }
            dataList.add(data);
        });
        return dataList;
    }

    public void imports(String cacheKey, List<AuditFeeValidationDetailDto> result) {
        this.saveCurrentPageCache(cacheKey, result);
    }
}

