/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormAuditDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.audit.fee.validation.local.cache.AuditFeeValidationDetailCacheHelper;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationInfoEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.repository.AuditFeeValidationInfoAttachmentRepository;
import com.biz.crm.tpm.business.audit.fee.validation.local.repository.AuditFeeValidationInfoRepository;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationInfoAttachmentService;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationInfoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationInfoAttachmentDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationDetailVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationInfoAttachmentVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="auditFeeValidationInfoService")
public class AuditFeeValidationInfoServiceImpl
implements AuditFeeValidationInfoService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeValidationInfoServiceImpl.class);
    @Resource
    private AuditFeeValidationInfoRepository auditFeeValidationInfoRepository;
    @Resource
    private AuditFeeValidationInfoAttachmentRepository auditFeeValidationInfoAttachmentRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private AuditFeeValidationInfoAttachmentService auditFeeValidationInfoAttachmentService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private AuditFeeValidationDetailVoService auditFeeValidationDetailVoService;
    @Resource
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private AuditFeeValidationDetailCacheHelper helper;

    @Override
    public void createOrUpdate(String auditCode, boolean isEdit, String cacheKey) {
        if (isEdit) {
            this.auditFeeValidationInfoRepository.deleteByAuditCode(auditCode);
        }
        List<AuditFeeValidationInfoVo> auditInfoList = this.getAuditInfoFromCache(cacheKey);
        log.info("\u4fdd\u5b58\u65f6\u6838\u9500\u8d44\u6599,{}", (Object)JSON.toJSONString(auditInfoList));
        if (CollectionUtils.isEmpty(auditInfoList)) {
            return;
        }
        ArrayList attachmentVos = Lists.newArrayList();
        for (AuditFeeValidationInfoVo o : auditInfoList) {
            o.setAuditCode(auditCode);
            o.setId(UuidCrmUtil.randomUuid());
            o.setTenantCode(TenantUtils.getTenantCode());
            if (CollectionUtils.isEmpty((Collection)o.getAuditInfoAttachmentList())) continue;
            o.getAuditInfoAttachmentList().forEach(att -> {
                att.setAuditCode(auditCode);
                att.setAuditInfoId(o.getId());
                o.setTenantCode(TenantUtils.getTenantCode());
            });
            attachmentVos.addAll(o.getAuditInfoAttachmentList());
        }
        List entities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditInfoList, AuditFeeValidationInfoVo.class, AuditFeeValidationInfoEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditFeeValidationInfoRepository.saveBatch(entities);
        this.auditFeeValidationInfoAttachmentService.save(auditCode, attachmentVos);
    }

    @Override
    public List<AuditFeeValidationInfoVo> findByAuditCode(String auditCode) {
        List<AuditFeeValidationInfoEntity> auditFeeInfos = this.auditFeeValidationInfoRepository.findByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(auditFeeInfos)) {
            return Lists.newArrayList();
        }
        List<AuditFeeValidationInfoAttachmentVo> attachmentVos = this.auditFeeValidationInfoAttachmentService.findByAuditCode(auditCode);
        Map<Object, Object> attachmentVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(attachmentVos)) {
            attachmentVoMap = attachmentVos.stream().collect(Collectors.groupingBy(AuditFeeValidationInfoAttachmentVo::getAuditInfoId));
        }
        List auditFeeValidationInfoVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditFeeInfos, AuditFeeValidationInfoEntity.class, AuditFeeValidationInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        for (AuditFeeValidationInfoVo auditFeeValidationInfoVo : auditFeeValidationInfoVos) {
            List attachmentVos1 = (List)attachmentVoMap.get(auditFeeValidationInfoVo.getId());
            if (CollectionUtils.isEmpty((Collection)attachmentVos1)) continue;
            auditFeeValidationInfoVo.setAuditInfoAttachmentList(attachmentVos1);
        }
        return auditFeeValidationInfoVos;
    }

    @Override
    public List<AuditFeeValidationInfoVo> findAuditInfo(AuditFeeValidationDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String cacheKey = dto.getCacheKey();
        String key = this.helper.getRedisCacheIdKey(cacheKey);
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key))) {
            List detailDtoList = this.auditFeeValidationDetailVoService.findCacheList(cacheKey);
            log.info("\u67e5\u770b\u6838\u9500\u8d44\u6599\u6240\u6709\u660e\u7ec6,{}", (Object)JSON.toJSONString((Object)detailDtoList));
            if (CollectionUtils.isEmpty((Collection)detailDtoList)) {
                return Lists.newArrayList();
            }
            Set activityFormCodes = detailDtoList.stream().map(AuditFeeValidationDetailDto::getActivityFormCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            List<AuditFeeValidationInfoVo> auditInfoFromCache = this.getAuditInfoFromCache(cacheKey);
            log.info("\u67e5\u770b\u6838\u9500\u8d44\u6599\u7f13\u5b58\u8d44\u6599,{}", (Object)JSON.toJSONString(auditInfoFromCache));
            Map<Object, Object> auditInfoCacheMap = new HashMap();
            if (!CollectionUtils.isEmpty(auditInfoFromCache)) {
                auditInfoCacheMap = auditInfoFromCache.stream().collect(Collectors.groupingBy(AuditFeeValidationInfoVo::getActivityFormCode));
            }
            ArrayList<AuditFeeValidationInfoVo> auditInfoVoList = new ArrayList<AuditFeeValidationInfoVo>();
            Set<Object> addActivityFormCodes = new HashSet();
            if (!CollectionUtils.isEmpty(auditInfoFromCache) && auditInfoFromCache.size() > 0) {
                for (String activityFormCode : activityFormCodes) {
                    List auditFeeValidationInfoVos = (List)auditInfoCacheMap.get(activityFormCode);
                    if (CollectionUtils.isEmpty((Collection)auditFeeValidationInfoVos)) {
                        addActivityFormCodes.add(activityFormCode);
                        continue;
                    }
                    auditInfoVoList.addAll(auditFeeValidationInfoVos);
                }
            } else {
                addActivityFormCodes = activityFormCodes;
            }
            log.info("\u67e5\u770b\u6838\u9500\u8d44\u6599\u6240\u6709\u5f62\u5f0f\u7f16\u7801,{}", (Object)JSON.toJSONString(addActivityFormCodes));
            if (!CollectionUtils.isEmpty(addActivityFormCodes)) {
                List activityFormVos = this.activityFormService.findActivityFormByCode(addActivityFormCodes);
                log.info("\u67e5\u770b\u6838\u9500\u8d44\u6599\u5f62\u5f0f\u5e26\u51fa\u8d44\u6599,{}", (Object)JSON.toJSONString((Object)activityFormVos));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activityFormVos)) {
                    for (ActivityFormVo activityFormVo : activityFormVos) {
                        List activityFormAuditDtoList = activityFormVo.getActivityFormAuditDtoList();
                        if (CollectionUtils.isEmpty((Collection)activityFormAuditDtoList)) continue;
                        for (ActivityFormAuditDto activityFormAuditDto : activityFormAuditDtoList) {
                            AuditFeeValidationInfoVo auditInfoVo = new AuditFeeValidationInfoVo();
                            auditInfoVo.setId(UUID.randomUUID().toString().replace("-", ""));
                            auditInfoVo.setActivityFormCode(activityFormVo.getActivityFormCode());
                            auditInfoVo.setActivityFormName(activityFormVo.getActivityFormName());
                            if (Objects.nonNull(activityFormAuditDto.getMnApprovalCollect())) {
                                auditInfoVo.setDescription(activityFormAuditDto.getMnApprovalCollect().getName());
                            }
                            auditInfoVoList.add(auditInfoVo);
                        }
                    }
                }
            }
            List infoVos = auditInfoVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AuditFeeValidationInfoVo>(Comparator.comparing(a -> a.getActivityFormCode() + a.getDescription()))), ArrayList::new));
            return infoVos;
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getAuditCode())) {
            String auditCode = dto.getAuditCode();
            List<AuditFeeValidationInfoVo> auditFeeValidationInfoVos = this.findByAuditCode(auditCode);
            this.saveAuditInfoCache(cacheKey, auditFeeValidationInfoVos);
        }
        return Lists.newArrayList();
    }

    @Override
    public void saveAuditInfoCache(AuditFeeValidationDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)" \u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getAuditInfoList())) {
            log.info("\u6838\u9500\u8d44\u6599\u62f7\u8d1d\u524d,{}", (Object)JSON.toJSONString((Object)dto.getAuditInfoList()));
            List<AuditFeeValidationInfoVo> auditFeeValidationInfoVos = dto.getAuditInfoList().stream().map(e -> {
                AuditFeeValidationInfoVo vo = new AuditFeeValidationInfoVo();
                BeanUtils.copyProperties((Object)e, (Object)vo);
                vo.setAuditInfoAttachmentList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)e.getAuditInfoAttachmentList(), AuditFeeValidationInfoAttachmentDto.class, AuditFeeValidationInfoAttachmentVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                return vo;
            }).collect(Collectors.toList());
            log.info("\u6838\u9500\u8d44\u6599\u62f7\u8d1d\u5b8c,{}", (Object)JSON.toJSONString(auditFeeValidationInfoVos));
            this.saveAuditInfoCache(dto.getCacheKey(), auditFeeValidationInfoVos);
        }
    }

    @Override
    public void saveAuditInfoCache(String cacheKey, List<AuditFeeValidationInfoVo> auditFeeValidationInfoVos) {
        if (StringUtils.isEmpty((CharSequence)cacheKey)) {
            return;
        }
        if (CollectionUtils.isEmpty(auditFeeValidationInfoVos)) {
            return;
        }
        if (!CollectionUtils.isEmpty(auditFeeValidationInfoVos)) {
            cacheKey = "audit_fee:info:" + cacheKey;
            this.redisTemplate.delete((Object)cacheKey);
            this.redisTemplate.opsForList().rightPushAll((Object)cacheKey, auditFeeValidationInfoVos.toArray());
            this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        }
    }

    private List<AuditFeeValidationInfoVo> getAuditInfoFromCache(String cacheKey) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        cacheKey = "audit_fee:info:" + cacheKey;
        List<Object> auditInfoVoList = new ArrayList<AuditFeeValidationInfoVo>();
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)cacheKey))) {
            List range = this.redisTemplate.opsForList().range((Object)cacheKey, 0L, -1L);
            auditInfoVoList = range;
        }
        this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        return auditInfoVoList;
    }
}

