/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.validation.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationDetailEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.helper.AuditFeeValidationHelper;
import com.biz.crm.tpm.business.audit.fee.validation.local.repository.AuditFeeValidationRepository;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationDetailService;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationDetailUseLedgerService;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationInfoService;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailUseLedgerDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.enums.SaveTypeEnum;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="AuditFeeValidationService")
public class AuditFeeValidationServiceImpl
implements AuditFeeValidationService {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeValidationServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Resource
    private AuditFeeValidationRepository auditFeeValidationRepository;
    @Resource
    private AuditFeeValidationVoService auditFeeValidationVoService;
    @Resource
    private AuditFeeValidationHelper auditFeeValidationHelper;
    @Resource
    private AuditFeeValidationDetailService auditFeeValidationDetailService;
    @Resource
    private AuditFeeValidationInfoService auditFeeValidationInfoService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private AuditFeeValidationDetailUseLedgerService auditFeeValidationDetailUseLedgerService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrUpdate(AuditFeeValidationDto dto) {
        this.auditFeeValidationHelper.verifyParams(dto);
        boolean isEdit = YesOrNoEnum.YES.getCode().equals(dto.getIsEdit());
        if (!isEdit) {
            dto.setAuditCode(this.auditFeeValidationHelper.generateCode());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getProcessStatus())) {
            dto.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
        }
        AuditFeeValidationEntity entity = (AuditFeeValidationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditFeeValidationEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setTenantCode(TenantUtils.getTenantCode());
        List<AuditFeeValidationDetailDto> detailDtos = this.auditFeeValidationDetailService.createOrUpdate(entity.getAuditCode(), isEdit, dto.getCacheKey(), dto.getSaveType());
        List<String> detailCodes = detailDtos.stream().map(AuditFeeValidationDetailDto::getDetailCode).collect(Collectors.toList());
        List<AuditFeeValidationDetailDto> inApprovalCodes = this.auditFeeValidationDetailService.findInApprovalValidation(isEdit ? entity.getId() : null, entity.getAuditCode(), detailCodes, ProcessStatusEnum.PASS.getDictCode());
        if (!CollectionUtils.isEmpty(inApprovalCodes)) {
            AuditFeeValidationDetailDto msg = inApprovalCodes.get(0);
            throw new RuntimeException("\u5dee\u5f02\u8ffd\u8e2a\u660e\u7ec6\u3010" + msg.getDetailCode() + "\u3011\u6240\u5728\u3010" + msg.getAuditCode() + "\u3011\u5dee\u5f02\u7ed3\u6848\u6b63\u5728\u6d41\u7a0b\u4e2d\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u65b0\u7684\u6d41\u7a0b\uff0c\u8bf7\u5904\u7406\uff01");
        }
        this.auditFeeValidationInfoService.createOrUpdate(entity.getAuditCode(), isEdit, dto.getCacheKey());
        BigDecimal reduce = detailDtos.stream().map(AuditFeeValidationDetailDto::getThisAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setThisEndCaseTotalAmount(Optional.ofNullable(reduce).orElse(BigDecimal.ZERO));
        this.auditFeeValidationRepository.saveOrUpdate((Object)entity);
        if (SaveTypeEnum.SUBMIT.getCode().equals(dto.getSaveType())) {
            this.submitApproval(dto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(AuditFeeValidationDto dto) {
        Assert.notNull((Object)dto, (String)"\u63d0\u4ea4\u7684\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)dto.getProcessBusiness(), (String)"\u6d41\u7a0b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        AuditFeeValidationEntity entity = this.auditFeeValidationRepository.findByAuditCode(dto.getAuditCode());
        Assert.notNull((Object)((Object)entity), (String)("\u5355\u636e[" + dto.getAuditCode() + "]\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u65b0\u9009\u62e9\u5355\u636e!"));
        Validate.isTrue((ProcessStatusEnum.PREPARE.getDictCode().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(entity.getProcessStatus()) || StringUtils.isBlank((CharSequence)entity.getProcessStatus()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u6d41\u7a0b\u72b6\u6001\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279", (Object[])new Object[0]);
        this.operateAmount(dto.getCurrentOperateId(), dto.getAuditCode());
        ProcessBusinessDto processBusiness = Optional.ofNullable(dto.getProcessBusiness()).orElse(new ProcessBusinessDto());
        processBusiness.setBusinessNo(dto.getAuditCode());
        processBusiness.setProcessTitle("\u5dee\u5f02\u8d39\u7528\u7ed3\u6848[" + dto.getAuditName() + "]\u53d1\u8d77\u5ba1\u6279\u6d41");
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("tpm_audit_fee_process");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        this.auditFeeValidationRepository.updateProcessStatusByAuditCode(dto.getAuditCode(), ProcessStatusEnum.COMMIT, processBusinessVo.getProcessNo());
    }

    private void operateAmount(String currentOperateId, String auditCode) {
        FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        List<AuditFeeValidationDetailEntity> details = this.auditFeeValidationDetailService.findByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        List activityFormCodes = details.stream().map(AuditFeeValidationDetailEntity::getActivityFormCode).distinct().collect(Collectors.toList());
        List activityFormVoList = this.activityFormService.findByCodes(activityFormCodes);
        Validate.notEmpty((Collection)activityFormVoList, (String)"\u672a\u5728\u2018\u6d3b\u52a8\u5f62\u5f0f\u7ba1\u7406\u2019\u67e5\u8be2\u5230\u76f8\u5173\u6d3b\u52a8\u5f62\u5f0f\u4fe1\u606f", (Object[])new Object[0]);
        Map activityFormVoMap = activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity(), (v1, v2) -> v2));
        List detailCodes = details.stream().map(AuditFeeValidationDetailEntity::getDetailCode).distinct().collect(Collectors.toList());
        List ledgers = this.auditFeeDiffTrackDetailVoService.findLedgerByDetailCodes(detailCodes);
        Map<String, List<AuditFeeDiffTrackDetailLedgerVo>> ledgerVoMap = ledgers.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailLedgerVo::getDetailCode));
        ArrayList operateDto = Lists.newArrayList();
        ArrayList<AuditFeeValidationDetailUseLedgerDto> useLedgerList = new ArrayList<AuditFeeValidationDetailUseLedgerDto>();
        details.forEach(detail -> {
            detail.setAlreadyAuditAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)detail.getAlreadyAuditAmount(), (Object)BigDecimal.ZERO));
            detail.setThisAuditAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)detail.getThisAuditAmount(), (Object)BigDecimal.ZERO));
            detail.setApplyAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)detail.getApplyAmount(), (Object)BigDecimal.ZERO));
            BigDecimal amount = detail.getAlreadyAuditAmount().add(detail.getThisAuditAmount());
            if (amount.compareTo(detail.getApplyAmount()) > 0) {
                ActivityFormVo activityFormVo = (ActivityFormVo)activityFormVoMap.get(detail.getActivityFormCode());
                Validate.notNull((Object)activityFormVo, (String)("\u672a\u5728\u2018\u6d3b\u52a8\u5f62\u5f0f\u7ba1\u7406\u2019\u67e5\u8be2\u5230,\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u3010" + detail.getDetailCode() + "\u3011\u5173\u8054\u7684\u6d3b\u52a8\u5f62\u5f0f\u3010" + detail.getActivityFormCode() + "\u3011"), (Object[])new Object[0]);
                Validate.isTrue((boolean)activityFormVo.getIsAllowExcessAudit(), (String)("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u3010" + detail.getDetailCode() + "\u3011,\u4e0d\u5141\u8bb8\u8d85\u989d\u6838\u9500\uff0c\u8bf7\u4fee\u6539\u201c\u672c\u6b21\u7ed3\u6848\u91d1\u989d\u201d\uff01"), (Object[])new Object[0]);
                if (CollectionUtils.isEmpty((Map)ledgerVoMap) || CollectionUtils.isEmpty((Collection)((Collection)ledgerVoMap.get(detail.getDetailCode())))) {
                    throw new RuntimeException("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u3010" + detail.getDetailCode() + "\u3011,\u6ca1\u6709\u5173\u8054\u7684\u5dee\u5f02\u8d39\u7528\u53f0\u8d26\uff0c\u65e0\u6cd5\u62b5\u6263\u91d1\u989d");
                }
                BigDecimal recoveredAmountTotal = amount.subtract(detail.getApplyAmount());
                List ledgerVoList = (List)ledgerVoMap.get(detail.getDetailCode());
                ledgerVoList = ledgerVoList.stream().sorted(Comparator.comparing(UuidOpVo::getCreateTime)).collect(Collectors.toList());
                for (AuditFeeDiffTrackDetailLedgerVo auditFeeDiffTrackDetailLedgerVo : ledgerVoList) {
                    if (recoveredAmountTotal.compareTo(BigDecimal.ZERO) == 0) break;
                    BigDecimal beRecoveredAmount = Optional.ofNullable(auditFeeDiffTrackDetailLedgerVo.getBeRecoveredAmount()).orElse(BigDecimal.ZERO);
                    if (beRecoveredAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    AuditFeeDiffLedgerDeductionDto dto = new AuditFeeDiffLedgerDeductionDto();
                    dto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode());
                    dto.setFeeDiffLedgerCode(auditFeeDiffTrackDetailLedgerVo.getFeeDiffLedgerCode());
                    dto.setDataSource(DiffLedgerDataSourceEnum.DIFF_CLOSED.getCode());
                    dto.setBusinessCode(detail.getAuditDetailCode());
                    dto.setFeeDiffLedgerDisposeCode(detail.getDetailCode());
                    dto.setActivityFormCode(detail.getActivityFormCode());
                    dto.setActivityFormName(detail.getActivityFormName());
                    dto.setActivityTypeCode(detail.getActivityTypeCode());
                    dto.setActivityTypeName(detail.getActivityTypeName());
                    dto.setResaleCommercialCode(detail.getSystemCode());
                    dto.setResaleCommercialName(detail.getSystemName());
                    dto.setTerminalCode(detail.getTerminalCode());
                    dto.setTerminalName(detail.getTerminalName());
                    if (!Objects.isNull(loginUserDetails)) {
                        dto.setOperatorAccount(loginUserDetails.getAccount());
                    }
                    if (recoveredAmountTotal.compareTo(beRecoveredAmount) > 0) {
                        dto.setRecoveredAmount(beRecoveredAmount);
                        recoveredAmountTotal = recoveredAmountTotal.subtract(beRecoveredAmount);
                    } else {
                        dto.setRecoveredAmount(recoveredAmountTotal);
                        recoveredAmountTotal = BigDecimal.ZERO;
                    }
                    operateDto.add(dto);
                    AuditFeeValidationDetailUseLedgerDto useLedget = new AuditFeeValidationDetailUseLedgerDto();
                    useLedget.setOperationType(dto.getOperationType());
                    useLedget.setFeeDiffLedgerCode(dto.getFeeDiffLedgerCode());
                    useLedget.setRecoveredAmount(dto.getRecoveredAmount());
                    useLedget.setIsReturned(BooleanEnum.FALSE.getCapital());
                    useLedget.setAuditCode(detail.getAuditCode());
                    useLedget.setAuditDetailCode(detail.getAuditDetailCode());
                    useLedget.setPlanCode(detail.getPlanCode());
                    useLedget.setPlanName(detail.getPlanName());
                    useLedget.setDetailCode(detail.getDetailCode());
                    useLedgerList.add(useLedget);
                }
            }
        });
        if (CollectionUtils.isEmpty((Collection)operateDto)) {
            return;
        }
        this.operateAmount(currentOperateId, operateDto);
        if (!CollectionUtils.isEmpty(useLedgerList)) {
            this.auditFeeValidationDetailUseLedgerService.saveBatch(useLedgerList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void operateAmount(String currentOperateId, List<AuditFeeDiffLedgerDeductionDto> operateDto) {
        List lockKeys = operateDto.stream().map(AuditFeeDiffLedgerDeductionDto::getFeeDiffLedgerCode).distinct().collect(Collectors.toList());
        boolean lock = this.auditFeeDiffLedgerLockService.lock(lockKeys, TimeUnit.SECONDS, 60);
        Validate.isTrue((boolean)lock, (String)"\u7cfb\u7edf\u5176\u4ed6\u5355\u636e\u6b63\u5728\u5904\u7406\u5dee\u5f02\u8d39\u7528\u53f0\u8d26,\u8bf7\u7a0d\u540e\u518d\u64cd\u4f5c", (Object[])new Object[0]);
        this.redisService.set(String.format("audit_fee_validation:code:%s", currentOperateId), lockKeys);
        operateDto.forEach(e -> this.auditFeeDiffLedgerVoService.useAmount(e));
    }

    @Override
    @Async
    public void batchRelevance(UserIdentity loginUser, AuditFeeDiffTrackDetailDto dto) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        this.auditFeeValidationHelper.sendMsg("\u5f00\u59cb\u5173\u8054\u6570\u636e");
        int page = 1;
        int size = 1000;
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        Page resultPage = this.auditFeeDiffTrackDetailVoService.auditFindByConditions((Pageable)pageable, dto);
        List records = resultPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            this.auditFeeValidationHelper.sendMsg("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return;
        }
        this.auditFeeValidationHelper.sendMsg("\u67e5\u8be2\u7b2c" + page + "\u9875\u6570\u636e\uff0c\u5171\u6709" + resultPage.getTotal() + "\u6761\u6570\u636e");
        this.addDataToCache(dto.getCacheKey(), records);
        while (resultPage.hasNext()) {
            pageable = PageRequest.of((int)page++, (int)size);
            resultPage = this.auditFeeDiffTrackDetailVoService.auditFindByConditions((Pageable)pageable, dto);
            this.auditFeeValidationHelper.sendMsg("\u67e5\u8be2\u7b2c" + page + "\u9875\u6570\u636e\uff0c\u5171\u6709" + resultPage.getTotal() + "\u6761\u6570\u636e");
            records = resultPage.getRecords();
            this.addDataToCache(dto.getCacheKey(), records);
        }
        this.auditFeeValidationHelper.sendMsg("\u5173\u8054\u6570\u636e\u5b8c\u6210", ExecStatusEnum.FINISH.getDictCode());
    }

    private void addDataToCache(String cacheKey, List<AuditFeeDiffTrackDetailVo> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        List detailDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(records, AuditFeeDiffTrackDetailVo.class, AuditFeeValidationDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.auditFeeValidationDetailService.addItemCache(cacheKey, detailDtos);
        this.auditFeeValidationHelper.sendMsg("\u4fdd\u5b58\u5173\u8054\u6570\u636e");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u4e3b\u952eID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.auditFeeValidationRepository.deleteBatch(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u4e3b\u952eID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.auditFeeValidationRepository.enableBatch(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u4e3b\u952eID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.auditFeeValidationRepository.disableBatch(ids);
    }

    @Override
    public AuditFeeValidationVo findConditionByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        AuditFeeValidationEntity entity = this.auditFeeValidationRepository.findByAuditCode(auditCode);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        AuditFeeValidationVo vo = (AuditFeeValidationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditFeeValidationVo.class, null, null, new String[0]);
        List<AuditFeeValidationDetailEntity> detailEntityList = this.auditFeeValidationDetailService.findByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(detailEntityList)) {
            return vo;
        }
        List detailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailEntityList, AuditFeeValidationDetailEntity.class, AuditFeeValidationDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        vo.setDetailList(detailVos);
        return vo;
    }

    @Override
    public void updateProcessStatusByAuditCode(String auditCode, ProcessStatusEnum statusEnum, String processNo) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return;
        }
        this.auditFeeValidationRepository.updateProcessStatusByAuditCode(auditCode, statusEnum, processNo);
    }
}

