package com.biz.crm.tpm.business.audit.fee.validation.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 商超费用结案核销主表 常量类
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class AuditFeeValidationConstant {

    /**
     * 明细缓存key
     */
    public static final String AUDIT_FEE_VALIDATION_DETAIL_CACHE_KEY = "audit_fee:validation_detail_cache:";

    /**
     * 核销编码前缀
     */
    public static final String AUDIT_FEE_DIFF_VALIDATION = "AFDV";

    /**
     * 核销明细编码前缀
     */
    public static final String AUDIT_FEE_DIFF_VALIDATION_DETAIL = "AFDVD";

    /**
     * 核销资料缓存key
     */
    public static final String AUDIT_FEE_INFO_CACHE_KEY = "audit_fee:info:";

    /**
     * 编辑锁
     */
    public static final String AUDIT_FEE_EDIT_LOCK = "audit_fee:edit:";

    public static final String TPM_AUDIT_FEE_PROCESS = "tpm_audit_fee_process";

    public static final String AUDIT_FEE_SUBMIT_APPROVAL = "audit_fee:submit_approval";

    public static final String WEBSOCKET_MODEL_CODE_BATCH_RELEVANCE = "audit_fee_batch_relevance";

    public static final String AUDIT_FEE_VALIDATION_AMOUNT_LOCK = "audit_fee_validation:code:%s";
}