package com.biz.crm.tpm.business.audit.fee.validation.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description 明细
 * @Author wei·yang
 * @Date Created in 2023/9/27 15:11
 */
@ApiModel(value = "AuditFeeValidationDetailDto" , description = "明细")
@EqualsAndHashCode(callSuper = true)
@Data
public class AuditFeeValidationDetailDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "checked" , notes = "选中标识")
    private String checked;

    @ApiModelProperty(name = "核销code" , notes = "核销code")
    private String auditCode;

    @ApiModelProperty(name = "核销明细编码" , notes = "核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty(name = "差异追踪编码" , notes = "差异追踪编码")
    private String planCode;

    @ApiModelProperty(name = "差异追踪名称" , notes = "差异追踪名称")
    private String planName;

    @ApiModelProperty(name = "差异追踪明细编码" , notes = "差异追踪明细编码")
    private String detailCode;

    @ApiModelProperty(name = "活动类型" , notes = "活动类型")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称" , notes = "活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式" , notes = "活动形式")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称" , notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "活动开始时间" , notes = "活动开始时间")
    @JsonFormat(locale = "zh" , timezone = "GMT+8" , pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginTime;

    @ApiModelProperty(name = "活动结束时间" , notes = "活动结束时间")
    @JsonFormat(locale = "zh" , timezone = "GMT+8" , pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndTime;

    @ApiModelProperty("购买方式")
    private String buyWay;

    @ApiModelProperty("核销类型")
    private String auditType;

    @ApiModelProperty("核销条件编码")
    private String auditConditionCode;

    @ApiModelProperty("核销条件名称")
    private String auditConditionName;

    @ApiModelProperty(name = "核销公式编码" , notes = "核销code")
    private String auditFormulaCode;

    @ApiModelProperty(name = "核销公式名称" , notes = "核销公式名称")
    private String auditFormulaName;

    @ApiModelProperty(notes = "销售机构")
    private String salesInstitutionName;

    @ApiModelProperty(notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(notes = "销售机构编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(notes = "销售大区（销售部门）")
    private String salesRegionName;

    @ApiModelProperty(notes = "销售大区编码（销售部门）")
    private String salesRegionCode;

    @ApiModelProperty("销售组织(销售组，省区)")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称(销售组，省区)")
    private String salesOrgName;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty(name = "系统（零售商）" , notes = "系统")
    private String systemCode;

    @ApiModelProperty(name = "系统名称（零售商）" , notes = "系统名称")
    private String systemName;


    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    private String secondChannelCode;

    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    private String secondChannelName;

    @ApiModelProperty(name = "客户" , notes = "客户")
    private String customerCode;

    @ApiModelProperty(name = "客户名称" , notes = "客户名称")
    private String customerName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    private String customerErpCode;

    @ApiModelProperty(name = "门店编码" , notes = "门店编码")
    private String storeCode;

    @ApiModelProperty(name = "门店名称" , notes = "门店名称")
    private String storeName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码" , notes = "")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称" , notes = "")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码" , notes = "")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称" , notes = "")
    private String productCategoryName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码" , notes = "产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称" , notes = "产品名称")
    private String productName;

    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;

    @ApiModelProperty(name = "申请金额" , notes = "申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty(name = "预核销金额（预结案金额）" , notes = "预核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty(name = "已结案金额" , notes = "已结案金额")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty(name = "本次结案金额" , notes = "本次结案金额")
    private BigDecimal thisAuditAmount;

    @ApiModelProperty(name = "是否完全结案" , notes = "是否完全结案")
    private String wholeAudit;

    @ApiModelProperty("是否逾期")
    private String overdue;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店编码")
    private String terminalName;

    //=======冗余，用于字段装换======
    @ApiModelProperty("转为 表字段 applyAmount")
    private BigDecimal feeAmount;
}
