package com.biz.crm.tpm.business.audit.fee.validation.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/2 15:47
 * @description：核销资料
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "核销资料附件")
public class AuditFeeValidationInfoAttachmentDto extends TenantFlagOpDto {
    @ApiModelProperty(name = "核销code", notes = "核销code")
    private String auditCode;

    @ApiModelProperty(name = "核销资料id", notes = "核销资料id")
    private String auditInfoId;

    @ApiModelProperty(value = "文件唯一识别号")
    private String fileCode;

    /**
     * 原始文件名
     */
    @ApiModelProperty(name="originalFileName" , value="原始文件名")
    private String originalFileName;
}
