package com.biz.crm.tpm.business.audit.fee.validation.sdk.dto;

import com.biz.crm.business.common.sdk.dto.FileDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/2 15:49
 * @description：核销资料
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "核销资料")
public class AuditFeeValidationInfoDto extends FileDto {
    @ApiModelProperty(name = "核销code", notes = "核销code")
    private String auditCode;

    @ApiModelProperty(name = "活动形式code", notes = "活动形式code")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "描述", notes = "描述")
    private String description;

    @ApiModelProperty(name = "核销资料附件")
    private List<AuditFeeValidationInfoAttachmentDto> auditInfoAttachmentList;
}
