package com.biz.crm.tpm.business.audit.fee.validation.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 商超费用结案核销主表 枚举示例
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Getter
@AllArgsConstructor
public enum ExampleEnum {
  /**
   * 示例
   */
  test("1001" , "1001" , "示例" , "0"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过key获取 枚举值
   *
   * @param dictCode 字典值
   * @return 枚举值
   */
  public static ExampleEnum getByDictCode(String dictCode) {
    return Arrays.stream(ExampleEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }
}
