package com.biz.crm.tpm.business.audit.fee.validation.sdk.service;

import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateExportVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateImportVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailVo;

import java.util.List;
import java.util.Map;

/**
 * @Description 明细VoService
 * @Author wei·yang
 * @Date Created in 2023/9/27 15:30
 */
public interface AuditFeeValidationDetailVoService extends MnPageCacheService<AuditFeeValidationDetailVo, AuditFeeValidationDetailDto> {

    /**
     * 获取缓存中导出总数
     * @param cacheKey
     * @return
     */
    Integer getExportTotal(String cacheKey);

    /**
     * 获取缓存中导出数据
     * @param cacheKey
     * @return
     */
    List<AuditFeeValidationDetailUpdateExportVo> getExportData(String cacheKey);

    /**
     * 明细导入验证
     * @param importsVoList
     * @param cacheKey
     * @param errorMap
     * @return
     */
    List<AuditFeeValidationDetailDto> validate(List<AuditFeeValidationDetailUpdateImportVo> importsVoList, String cacheKey, Map<String, String> errorMap);

    /**
     * 导入到缓存
     * @param cacheKey
     * @param result
     */
    void imports(String cacheKey, List<AuditFeeValidationDetailDto> result);
}
