package com.biz.crm.tpm.business.audit.fee.validation.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 商超费用结案核销主表 外部接口
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
public interface AuditFeeValidationVoService {

  /**
   * ID获取详情
   * @param id
   * @return {@link AuditFeeValidationVo}
   */
  default AuditFeeValidationVo findById(String id) {
    return null;
  }

  /**
   * 主列表
   * @param pageable
   * @param dto
   * @return {@link Page}<{@link AuditFeeValidationVo}>
   */
  default Page<AuditFeeValidationVo> findByConditions(Pageable pageable, AuditFeeValidationDto dto) {
    return new Page<>();
  }

  /**
   * 查询不是已审批的追踪明细
   * @param detailCodeList
   * @return
   */
  List<String> findProcessStatusNotPass(List<String> detailCodeList);
}

