package com.biz.crm.tpm.business.audit.fee.validation.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @CLASS_DESCRIBE: 差异明细结案导出编辑
 * @AUTHOR: create by zkey on 2023-10-21
 */
@Data
@CrmExcelImport
public class AuditFeeValidationDetailUpdateImportVo extends CrmExcelVo {

    @CrmExcelColumn("ID")
    private String id;

    @CrmExcelColumn("差异追踪明细编码")
    private String detailCode;

    @CrmExcelColumn("差异追踪编码")
    private String planCode;

    @CrmExcelColumn("差异追踪名称")
    private String planName;

    @CrmExcelColumn("活动类型")
    private String activityTypeCode;

    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;

    @CrmExcelColumn("活动形式")
    private String activityFormCode;

    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    @CrmExcelColumn("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginTime;

    @CrmExcelColumn("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndTime;

    @CrmExcelColumn("购买方式")
    private String buyWay;

    @CrmExcelColumn("核销类型")
    private String auditType;

    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;

    @CrmExcelColumn("核销条件名称")
    private String auditConditionName;

    @CrmExcelColumn("核销公式编码")
    private String auditFormulaCode;

    @CrmExcelColumn("核销公式名称")
    private String auditFormulaName;

    @CrmExcelColumn("销售机构")
    private String salesInstitutionName;

    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(notes = "销售大区（销售部门）")
    private String salesRegionName;

    @ApiModelProperty(notes = "销售大区编码（销售部门）")
    private String salesRegionCode;

    @ApiModelProperty("销售组织(销售组，省区)")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称(销售组，省区)")
    private String salesOrgName;

    @CrmExcelColumn("区域")
    private String region;

    @CrmExcelColumn("零售商")
    private String systemCode;

    @CrmExcelColumn("零售商名称")
    private String systemName;

    @CrmExcelColumn("一级营销渠道编码")
    private String firstChannelCode;

    @CrmExcelColumn("一级营销渠道名称")
    private String firstChannelName;

    @CrmExcelColumn("二级营销渠道编码")
    private String secondChannelCode;

    @CrmExcelColumn("二级营销渠道名称")
    private String secondChannelName;

    @CrmExcelColumn("客户")
    private String customerCode;

    @CrmExcelColumn("客户名称")
    private String customerName;

    @ApiModelProperty("客户ERP编码")
    private String customerErpCode;

    @CrmExcelColumn("门店编码")
    private String storeCode;

    @CrmExcelColumn("门店名称")
    private String storeName;

    @CrmExcelColumn("品牌编码")
    private String productBrandCode;

    @CrmExcelColumn("品牌名称")
    private String productBrandName;

    @CrmExcelColumn("品类编码")
    private String productCategoryCode;

    @CrmExcelColumn("品类名称")
    private String productCategoryName;

    @CrmExcelColumn("品项编码")
    private String productItemCode;

    @CrmExcelColumn("品项名称")
    private String productItemName;

    @CrmExcelColumn("产品编码")
    private String productCode;

    @CrmExcelColumn("产品名称")
    private String productName;

    @CrmExcelColumn("申请金额")
    private BigDecimal applyAmount;

    @CrmExcelColumn("预结案金额")
    private BigDecimal auditAmount;

    @CrmExcelColumn("已结案金额")
    private BigDecimal alreadyAuditAmount;

    @CrmExcelColumn("本次结案金额")
    private String thisAuditAmountStr;
    private BigDecimal thisAuditAmount;

    @CrmExcelColumn("是否完全结案")
    private String wholeAudit;

    @ApiModelProperty("是否逾期")
    private String overdue;
}
