package com.biz.crm.tpm.business.audit.fee.validation.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/11/22
 */
@Data
@ApiModel(value = "AuditFeeValidationDetailUseLedgerVo", description = "抵扣台账记录vo")
public class AuditFeeValidationDetailUseLedgerVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "核销code" , notes = "核销code")
    private String auditCode;

    @ApiModelProperty(name = "核销明细编码" , notes = "核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty(name = "差异追踪编码" , notes = "差异追踪编码")
    private String planCode;

    @ApiModelProperty(name = "差异追踪名称" , notes = "差异追踪名称")
    private String planName;

    @ApiModelProperty(name = "差异追踪明细编码" , notes = "差异追踪明细编码")
    private String detailCode;

    @ApiModelProperty(name = "差异费用台账编码", notes = "差异费用台账编码")
    private String feeDiffLedgerCode;

    /**
     * 操作类型[audit_fee_diff_ledger_operation_type]
     */
    @ApiModelProperty(value = "操作类型[audit_fee_diff_ledger_operation_type]", notes = "")
    private String operationType;

    /**
     * 操作金额
     */
    @ApiModelProperty(name = "recoveredAmount", notes = "操作金额", value = "操作金额")
    private BigDecimal recoveredAmount;

    /**
     * 是否回退 （审批驳回等，会将抵扣金额（操作金额）回退给差异费用台账
     */
    @ApiModelProperty(value = "是否回退", notes = "")
    private String isReturned;

}
