package com.biz.crm.tpm.business.audit.fee.validation.sdk.vo;

import lombok.Getter;
import lombok.Setter;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import java.util.List;
import java.util.Date;

/**
 * 商超费用结案核销主表
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AuditFeeValidationVo", description = "商超费用结案核销主表Vo")
public class AuditFeeValidationVo extends TenantFlagOpVo {

    /**
     * 明细缓存key
     */
    @ApiModelProperty(value = "明细缓存key")
    private String cacheKey;

    @ApiModelProperty(name = "核销code", notes = "核销code")
    private String auditCode;

    @ApiModelProperty(name = "核销申请名称", notes = "核销申请名称")
    private String auditName;

    @ApiModelProperty(name = "结案审批状态", notes = "结案审批状态")
    private String processStatus;

    @ApiModelProperty(name = "结案审批流程编码", notes = "结案审批流程编码")
    private String processNo;

    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "本次结案金额汇总", notes = "本次结案金额汇总")
    private BigDecimal thisEndCaseTotalAmount;

    @ApiModelProperty("hr组织(部门编码)")
    private String orgCode;

    @ApiModelProperty("hr组织名称（部门名称）")
    private String orgName;

    @ApiModelProperty("审批时间")
    private Date processDate;

    /**
     * 保存类型
     */
    @ApiModelProperty(name = "保存类型", notes = "")
    private String saveType;

    /**
     * 区域编码(字典MDM_CUSTOMIZE_ORG)
     */
    @ApiModelProperty(name = "区域编码", notes = "")
    private String regionCode;

    /**
     * 核销资料
     */
    @ApiModelProperty("核销资料")
    private List<AuditFeeValidationInfoVo> auditInfoList;

    @ApiModelProperty("明细")
    private List<AuditFeeValidationDetailVo> detailList;
}