package com.biz.crm.tpm.business.audit.invoice.manage.local.bean;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.enums.InvoiceCheckTypeEnum;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageMsgVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @author: chenlong
 * @date: 2023/4/6 10:45
 * @description: 发票上传消息推送
 */
@Component
@Slf4j
public class AuditInvoiceManageMsgBean {

    @Value("${spring.application.name}")
    private String applicationName;
    @Autowired(required = false)
    private ChannelMsgService channelMsgService;

    /**
     * 发票上传模块中
     */
    private static final String AUDIT_INVOICE_MANAGE_MODEL_CODE = "audit_invoice_manage_model";

    /**
     * 发送消息
     *
     * @param fileCode 文件唯一code
     * @param fileName 文件名
     * @param typeEnum 执行状态
     * @param remark   备注信息
     * @param account  登陆人账号
     */
    public void sendProcessMsg(String fileCode, String fileName, InvoiceCheckTypeEnum typeEnum, String remark, String account,String execStatus) {
        AuditInvoiceManageMsgVo vo = new AuditInvoiceManageMsgVo();
        vo.setFileCode(fileCode);
        vo.setFileName(fileName);
        if (StringUtils.isNotBlank(remark)) {
            vo.setCheckType(typeEnum.getDes() + remark);
        } else {
            vo.setCheckType(typeEnum.getDes());
        }
        vo.setRemark(remark);
        vo.setAccount(account);
        vo.setExecStatus(execStatus);
        this.sendProcessMsg(vo);
    }

    public void sendProcessMsg(String fileCode, String fileName, InvoiceCheckTypeEnum typeEnum, String remark, String account) {
        sendProcessMsg(fileCode,fileName,typeEnum,remark,account, ExecStatusEnum.RUNNING.getKey());
    }


    /**
     * 发送进度消息
     *
     * @param vo 进度消息实体
     */
    private void sendProcessMsg(AuditInvoiceManageMsgVo vo) {
        vo.setTime(new Date());
        byte[] jsonBytes = JSONObject.toJSONBytes(vo);
        String tenantCode = TenantUtils.getTenantCode();
        log.info(" import model send msg: tenantCode = {} , applicationName = {} , modelCode = {} ", tenantCode, applicationName, AUDIT_INVOICE_MANAGE_MODEL_CODE);
        if (StringUtils.isNotBlank(vo.getAccount())) {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, applicationName, AUDIT_INVOICE_MANAGE_MODEL_CODE, vo.getAccount(), jsonBytes);
        } else {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, applicationName, AUDIT_INVOICE_MANAGE_MODEL_CODE, jsonBytes);
        }
    }
}
