package com.biz.crm.tpm.business.audit.invoice.manage.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceAuditDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceAuditVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageFileSdkVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageFileVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageVo;
import com.bizunited.nebula.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

/**
 * @author: chenlong
 * @date: 2022/11/12 17:59
 * @description: 结案核销-发票管理表(AuditInvoiceManage)表相关的http接口
 */
@RestController
@RequestMapping("/v1/auditInvoiceManage")
@Slf4j
@Api(tags = "结案核销-发票管理")
public class AuditInvoiceManageController extends BaseController {

    @Autowired
    private AuditInvoiceManageService auditInvoiceManageService;
    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 分页查询所有数据
     *
     * @param pageable              分页对象
     * @param auditInvoiceManageDto 查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<AuditInvoiceManageVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "auditInvoiceManageDto", value = "结案核销发票管理主表Dto") AuditInvoiceManageDto auditInvoiceManageDto) {
        try {
            Page<AuditInvoiceManageVo> page = this.auditInvoiceManageService.findByConditions(pageable, auditInvoiceManageDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询有可用余额的数据(结案核销选择发票使用)
     *
     * @param pageable              分页对象
     * @param auditInvoiceManageDto 查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询有可用余额的数据(结案核销选择发票使用)")
    @GetMapping("findBalanceByConditions")
    public Result<Page<AuditInvoiceManageVo>> findBalanceByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                      @ApiParam(name = "auditInvoiceManageDto", value = "结案核销发票管理主表Dto") AuditInvoiceManageDto auditInvoiceManageDto) {
        try {
            Page<AuditInvoiceManageVo> page = this.auditInvoiceManageService.findBalanceByConditions(pageable, auditInvoiceManageDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<AuditInvoiceManageVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            AuditInvoiceManageVo activityApplyRulesVo = this.auditInvoiceManageService.findById(id);
            return Result.ok(activityApplyRulesVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据(结案核销使用，同步方法)
     *
     * @param auditInvoiceManageDto dto对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据(结案核销使用，同步方法)")
    @PostMapping
    public Result<List<AuditInvoiceManageVo>> create(@ApiParam(name = "auditInvoiceManageDto", value = "结案核销发票管理主表Dto") @RequestBody AuditInvoiceManageDto auditInvoiceManageDto) {
        try {
            List<AuditInvoiceManageVo> list = this.auditInvoiceManageService.create(auditInvoiceManageDto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据(发票报销管理使用 异步)
     *
     * @param auditInvoiceManageDto dto对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据(发票报销管理使用 异步)")
    @PostMapping("createAsync")
    public Result<?> createAsync(@ApiParam(name = "auditInvoiceManageDto", value = "结案核销发票管理主表Dto") @RequestBody AuditInvoiceManageDto auditInvoiceManageDto) {
        try {
            FacturerUserDetails identity = loginUserService.getLoginDetails(FacturerUserDetails.class);
            this.auditInvoiceManageService.createAsync(auditInvoiceManageDto, identity);
            return Result.ok("发票识别中，请稍等");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 手动录入新增数据
     *
     * @param auditInvoiceManageDto dto对象
     * @return 新增结果
     */
    @ApiOperation(value = "手动录入新增数据")
    @PostMapping("manualCreate")
    public Result<?> manualCreate(@ApiParam(name = "auditInvoiceManageDto", value = "结案核销发票管理主表Dto") @RequestBody AuditInvoiceManageDto auditInvoiceManageDto) {
        try {
            this.auditInvoiceManageService.manualCreate(auditInvoiceManageDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 手动录入编辑数据
     *
     * @param auditInvoiceManageDto dto对象
     * @return 新增结果
     */
    @ApiOperation(value = "手动录入编辑数据")
    @PostMapping("manualUpdate")
    public Result<?> manualUpdate(@ApiParam(name = "auditInvoiceManageDto", value = "结案核销发票管理主表Dto") @RequestBody AuditInvoiceManageDto auditInvoiceManageDto) {
        try {
            this.auditInvoiceManageService.manualUpdate(auditInvoiceManageDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping("delete")
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditInvoiceManageService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用0
     *
     * @param ids 主键列表
     * @return 启用结果
     */
    @ApiOperation(value = "启用", httpMethod = "PATCH")
    @PatchMapping("/enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.auditInvoiceManageService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids 主键列表
     * @return 禁用结果
     */
    @ApiOperation(value = "禁用", httpMethod = "PATCH")
    @PatchMapping("/disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.auditInvoiceManageService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询关联核销明细
     *
     * @param pageable 分页对象
     * @param auditDto 查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询关联核销明细")
    @GetMapping("findAuditByConditions")
    public Result<Page<AuditInvoiceAuditVo>> findAuditByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                   @ApiParam(name = "auditDto", value = "结案核销发票管理-关联核销明细Dto") AuditInvoiceAuditDto auditDto) {
        try {
            Page<AuditInvoiceAuditVo> page = this.auditInvoiceManageService.findAuditByConditions(pageable, auditDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询关联发票明细")
    @GetMapping("findByNoAndCode")
    public Result<AuditInvoiceManageVo> findByNoAndCode(@ApiParam(name = "auditDto", value = "结案核销发票管理-关联核销明细Dto") AuditInvoiceManageDto auditDto) {
        try {
            AuditInvoiceManageVo page = this.auditInvoiceManageService.findByNoAndCode(auditDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据发票id下载附件压缩包
     *
     * @param request  request
     * @param response response
     * @param ids      id列表
     * @throws IOException
     */
    @ApiOperation(value = "根据发票id下载附件压缩包")
    @RequestMapping(value = "/download", method = RequestMethod.GET)
    public void download(HttpServletRequest request, HttpServletResponse response, @RequestParam("ids") List<String> ids) throws IOException {
        byte[] bytes = this.auditInvoiceManageService.findFileZipByIds(ids);
        if (bytes == null) {
            return;
        }
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        String fileName = "发票附件-" + loginDetails.getRealName() + "-" + UUID.randomUUID().toString().replace("-", "") + ".zip";
        // 附件文件下载
        this.writeResponseFile(request, response, bytes, fileName);
    }

    /**
     * 根据发票号码下载附件压缩包
     *
     * @param request    request
     * @param response   response
     * @param invoiceNos 号码列表
     * @throws IOException
     */
    @ApiOperation(value = "根据发票号码下载附件压缩包")
    @RequestMapping(value = "/downloadByInvoiveNo", method = RequestMethod.GET)
    public void downloadByInvoiveNo(HttpServletRequest request, HttpServletResponse response, @RequestParam("invoiceNos") List<String> invoiceNos) throws IOException {
        byte[] bytes = this.auditInvoiceManageService.findFileZipByInvoiveNos(invoiceNos);
        if (bytes == null) {
            return;
        }
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        String fileName = "发票附件-" + loginDetails.getRealName() + "-" + UUID.randomUUID().toString().replace("-", "") + ".zip";
        // 附件文件下载
        this.writeResponseFile(request, response, bytes, fileName);
    }

    /**
     * 根据发票id查询发票附件
     *
     * @param ids     id列表
     */
    @ApiOperation(value = "根据发票id查询发票附件")
    @PostMapping("/findInvoiceFileData")
    public Result<List<AuditInvoiceManageFileSdkVo>> findInvoiceFileData(@RequestBody List<String> ids) {
        try {
            List<AuditInvoiceManageFileSdkVo> list = this.auditInvoiceManageService.findInvoiceFileData(ids);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
