package com.biz.crm.tpm.business.audit.invoice.manage.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author chenlong
 * @date 2022/11/12 17:11
 * @description 结案核销-发票管理
 */
@ApiModel(value = "AuditInvoiceManage", description = "结案核销-发票管理")
@TableName("tpm_audit_invoice_manage")
@Getter
@Setter
@Entity(name = "tpm_audit_invoice_manage")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_invoice_manage", comment = "结案核销-发票管理")
@Table(name = "tpm_audit_invoice_manage", indexes = {
        @Index(name = "TPM_AUDIT_INVOICE_MANAGE_INDEX1", columnList = "invoice_crm_code", unique = true),
        @Index(name = "TPM_AUDIT_INVOICE_MANAGE_INDEX2", columnList = "invoice_no")})
public class AuditInvoiceManage extends TenantFlagOpEntity {

    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "组织编码", notes = "组织编码")
    @Column(name = "org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty(name = "组织名称", notes = "组织名称")
    @Column(name = "org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sale_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String saleOrgCode;

    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sale_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售组织名称'")
    private String saleOrgName;

    @ApiModelProperty(name = "区域编码", notes = "区域编码")
    @Column(name = "area_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码'")
    private String areaCode;

    @ApiModelProperty(name = "区域名称", notes = "区域名称")
    @Column(name = "area_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '区域名称'")
    private String areaName;

    @ApiModelProperty("是否实质性发票")
    @Column(name = "is_material_invoice", length = 10, columnDefinition = "varchar(10) COMMENT '是否实质性发票'")
    private String isMaterialInvoice;

    @ApiModelProperty("发票编码(系统自动生成)")
    @Column(name = "invoice_crm_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '发票编码(系统自动生成)'")
    private String invoiceCrmCode;

    @ApiModelProperty("发票类型")
    @Column(name = "invoice_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '发票类型'")
    private String invoiceType;

    @ApiModelProperty("发票代码")
    @Column(name = "invoice_code", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '发票代码'")
    private String invoiceCode;

    @ApiModelProperty("发票号码(只允许填写数字和字母)")
    @Column(name = "invoice_no", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '发票号码(只允许填写数字和字母)'")
    private String invoiceNo;

    @ApiModelProperty("开票日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "billing_date", length = 20, columnDefinition = "datetime COMMENT '开票日期 '")
    private Date billingDate;

    @ApiModelProperty("校验码(只允许填写数字和字母)")
    @Column(name = "check_code", length = 64, columnDefinition = "varchar(64) COMMENT '校验码(只允许填写数字和字母)'")
    private String checkCode;

    @ApiModelProperty("购买方名称")
    @Column(name = "purchaser", length = 64, columnDefinition = "varchar(64) COMMENT '购买方名称'")
    private String purchaser;

    @ApiModelProperty("购买方税号")
    @Column(name = "p_no", length = 64, columnDefinition = "varchar(64) COMMENT '购买方税号'")
    private String pNo;

    @ApiModelProperty("购买方开户行及账号")
    @Column(name = "p_bank_and_account", length = 64, columnDefinition = "varchar(64) COMMENT '购买方开户行及账号'")
    private String pBankAndAccount;

    @ApiModelProperty("购买方地址电话")
    @TableField(value = "p_address_and_phone")
    @Column(name = "p_address_and_phone", length = 64, columnDefinition = "varchar(64) COMMENT '购买方地址电话'")
    private String pAddressAndPhone;

    @ApiModelProperty("销售方名称")
    @Column(name = "seller", length = 64, columnDefinition = "varchar(64) COMMENT '销售方名称'")
    private String seller;

    @ApiModelProperty("销售方税号")
    @Column(name = "s_no", length = 64, columnDefinition = "varchar(64) COMMENT '销售方税号'")
    private String sNo;

    @ApiModelProperty("销售方开户行及账号")
    @Column(name = "s_bank_and_account", length = 64, columnDefinition = "varchar(64) COMMENT '销售方开户行及账号'")
    private String sBankAndAccount;

    @ApiModelProperty("销售方地址电话")
    @Column(name = "s_address_and_phone", length = 255, columnDefinition = "varchar(255) COMMENT '销售方地址电话'")
    private String sAddressAndPhone;

    @ApiModelProperty("税价合计(含税金额)")
    @Column(name = "price_and_tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '税价合计'")
    private BigDecimal priceAndTax;

    @ApiModelProperty("不含税金额")
    @Column(name = "amount_without_tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '不含税金额'")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty("税率")
    @Column(name = "tax_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    @Column(name = "tax_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '税额'")
    private BigDecimal taxAmount;

    @ApiModelProperty("已使用金额")
    @Column(name = "use_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '已使用金额'")
    private BigDecimal useAmount;

    @ApiModelProperty("可用余额")
    @Column(name = "able_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '可用余额'")
    private BigDecimal ableAmount;

    @ApiModelProperty("文件唯一识别号")
    @Column(name = "file_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
    private String fileCode;

    @ApiModelProperty("文件名")
    @Column(name = "file_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '文件名'")
    private String fileName;

    @ApiModelProperty(name = "原始文件名", notes = "原始文件名")
    @Column(name = "original_file_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '原始文件名'")
    private String originalFileName;

    @ApiModelProperty("是否手动录入")
    @Column(name = "is_manual", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否手动录入'")
    private String isManual;

    @ApiModelProperty("是否使用")
    @Column(name = "is_use", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否使用:Y是N否'")
    private String isUse;

    @ApiModelProperty("发票使用年月")
    @Column(name = "use_years", length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票使用年月'")
    private String useYears;
}
