package com.biz.crm.tpm.business.audit.invoice.manage.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author chenlong
 * @date 2022/11/12 17:11
 * @description 结案核销-发票管理
 */
@ApiModel(value = "AuditInvoiceManageFile", description = "结案核销-发票管理-发票文件")
@TableName("tpm_audit_invoice_manage_file")
@Getter
@Setter
@Entity(name = "tpm_audit_invoice_manage_file")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_invoice_manage_file", comment = "结案核销-发票管理-发票文件")
@Table(name = "tpm_audit_invoice_manage_file", indexes = {
        @Index(name = "TPM_AUDIT_INVOICE_MANAGE_INDEX1", columnList = "invoice_crm_code", unique = true),
        @Index(name = "TPM_AUDIT_INVOICE_MANAGE_INDEX2", columnList = "invoice_no")})
public class AuditInvoiceManageFile extends TenantFlagOpEntity {

    @ApiModelProperty("发票编码(系统自动生成)")
    @Column(name = "invoice_crm_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '发票编码(系统自动生成)'")
    private String invoiceCrmCode;

    @ApiModelProperty("发票号码(只允许填写数字和字母)")
    @Column(name = "invoice_no", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '发票号码(只允许填写数字和字母)'")
    private String invoiceNo;

    @ApiModelProperty("文件唯一识别号")
    @Column(name = "file_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
    private String fileCode;

    @ApiModelProperty("文件名")
    @Column(name = "file_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '文件名'")
    private String fileName;

    @ApiModelProperty("文件大小")
    @Column(name = "file_size", length = 24, columnDefinition = "decimal(24,6) COMMENT '文件大小'")
    private Integer fileSize;

    @ApiModelProperty("有效期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "effective_date", length = 24, columnDefinition = "datetime COMMENT '有效期'")
    private Date effectiveDate;

    @ApiModelProperty("相对路径")
    @Column(name = "relative_local", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
    private String relativeLocal;

    @ApiModelProperty(name = "原始文件名", notes = "原始文件名")
    @Column(name = "original_file_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '原始文件名'")
    private String originalFileName;

    @ApiModelProperty("文件后缀")
    @Column(name = "prefix", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
    private String prefix;

    @ApiModelProperty("提交人")
    @Column(name = "commit_user", length = 64, columnDefinition = "VARCHAR(64) COMMENT '提交人'")
    private String commitUser;

}
