package com.biz.crm.tpm.business.audit.invoice.manage.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author chenlong
 * @date 2022/11/12 17:11
 * @description 结案核销-发票行明细
 */
@ApiModel(value = "AuditInvoiceManageItem", description = "结案核销-发票行明细")
@TableName("tpm_audit_invoice_manage_item")
@Getter
@Setter
@Entity(name = "tpm_audit_invoice_manage_item")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_invoice_manage_item", comment = "结案核销-发票行明细")
@Table(name = "tpm_audit_invoice_manage_item", indexes = {
        @Index(name = "TPM_AUDIT_INVOICE_MANAGE_INDEX2", columnList = "invoice_no")})
public class AuditInvoiceManageItem extends TenantFlagOpEntity {

    @ApiModelProperty("发票号码(只允许填写数字和字母)")
    @Column(name = "invoice_no", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '发票号码(只允许填写数字和字母)'")
    private String invoiceNo;

    @ApiModelProperty("发票编码(系统自动生成)")
    @Column(name = "invoice_crm_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '发票编码(系统自动生成)'")
    private String invoiceCrmCode;

    @ApiModelProperty("行号")
    @Column(name = "item_no", length = 10, columnDefinition = "varchar(10) COMMENT '行号'")
    private String itemNo;

    @ApiModelProperty("商品编码")
    @Column(name = "goods_code", length = 64, columnDefinition = "varchar(64) COMMENT '商品编码'")
    private String goodsCode;

    @ApiModelProperty("货物或应税劳务名称")
    @Column(name = "goods_taxable_name", length = 64, columnDefinition = "varchar(128) COMMENT '货物或应税劳务名称'")
    private String goodsTaxableName;

    @ApiModelProperty("规格型号/航班号/车次")
    @Column(name = "spec_model", length = 32, columnDefinition = "varchar(32) COMMENT '规格型号/航班号/车次'")
    private String specModel;

    @ApiModelProperty("单位/舱位/座席")
    @Column(name = "unit_seat", length = 32, columnDefinition = "varchar(32) COMMENT '单位/舱位/座席'")
    private String unitSeat;

    @ApiModelProperty("购买数量 0 无效")
    @Column(name = "purchase_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '购买数量 0 无效'")
    private BigDecimal purchaseQuantity;

    @ApiModelProperty("单价")
    @Column(name = "unit_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '单价'")
    private BigDecimal unitPrice;

    @ApiModelProperty("金额")
    @Column(name = "amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '金额'")
    private BigDecimal amount;

    @ApiModelProperty("税率")
    @Column(name = "tax_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    @Column(name = "tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '税额'")
    private BigDecimal tax;

    @ApiModelProperty("车牌号")
    @Column(name = "car_license", length = 12, columnDefinition = "varchar(12) COMMENT '车牌号'")
    private String carLicense;

    @ApiModelProperty("通行日期始出发日期时间字符串")
    @Column(name = "start_date", length = 20, columnDefinition = "varchar(20) COMMENT '通行日期始出发日期时间字符串 '")
    private String startDate;

    @ApiModelProperty("通行日期止出发日期时间字符串")
    @Column(name = "end_date", length = 20, columnDefinition = "varchar(20) COMMENT '通行日期止出发日期时间字符串 '")
    private String endDate;

    @ApiModelProperty("城市名称用,隔开")
    @Column(name = "city_name", length = 256, columnDefinition = "varchar(256) COMMENT '城市名称用,隔开'")
    private String cityName;

    @ApiModelProperty("城市编号用,隔开")
    @Column(name = "city_code", length = 256, columnDefinition = "varchar(256) COMMENT '城市编号用,隔开'")
    private String cityCode;

    @ApiModelProperty("出口站")
    @Column(name = "exit_station", length = 256, columnDefinition = "varchar(256) COMMENT '出口站'")
    private String exitStation;

    @ApiModelProperty("入口站")
    @Column(name = "entrance_station", length = 256, columnDefinition = "varchar(256) COMMENT '入口站'")
    private String entranceStation;
}
