package com.biz.crm.tpm.business.audit.invoice.manage.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageExportVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/8/7  20:35
 * @Description: 发票管理导出
 */
@Component
@Slf4j
public class AuditInvoiceManageExportProcess implements ExportProcess<AuditInvoiceManageExportVo> {

    private static final String TPM_AUDIT_INVOICE_TYPE = "tpm_audit_invoice_type";

    @Autowired(required = false)
    private AuditInvoiceManageService auditInvoiceManageService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }
    @Override
    public Integer getTotal(Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        PageRequest pageRequest = PageRequest.of(1, 1);
        AuditInvoiceManageDto dto = convertParams(params);
        Page<AuditInvoiceManageVo> auditInvoiceManageVoPage = auditInvoiceManageService.findByConditions(pageRequest, dto);
        Validate.isTrue(auditInvoiceManageVoPage.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return (int)auditInvoiceManageVoPage.getTotal();
    }

    private AuditInvoiceManageDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        return JSON.parseObject(JSON.toJSONString(params), AuditInvoiceManageDto.class);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);

        Pageable pageRequest = PageRequest.of(vo.getPageNo() + 1, getPageSize());
        AuditInvoiceManageDto dto = convertParams(params);
        Page<AuditInvoiceManageVo> auditInvoiceManageVoPage = auditInvoiceManageService.findByConditions(pageRequest, dto);
        List<AuditInvoiceManageVo> records = auditInvoiceManageVoPage.getRecords();
        if(CollectionUtils.isEmpty(records)){
            new JSONArray();
        }

        fillData(records);
        return JSON.parseArray(JSON.toJSONString(records, SerializerFeature.WriteDateUseDateFormat));
    }

    private void fillData(List<AuditInvoiceManageVo> records) {

        List<DictDataVo> dataVos = dictDataVoService.findByDictTypeCode(TPM_AUDIT_INVOICE_TYPE);
        Map<String, DictDataVo> auditInvoiceTypeMap = dataVos.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        records.forEach(item->{
            item.setTaxRate(item.getTax());
            DictDataVo dictDataVo = auditInvoiceTypeMap.get(item.getInvoiceType());
            if(dictDataVo!=null){
                item.setInvoiceType(dictDataVo.getDictValue());
            }
        });
    }

    @Override
    public String getBusinessCode() {
        return "audit_invoice_manage_export";
    }

    @Override
    public String getBusinessName() {
        return "核销发票导出";
    }
}
