package com.biz.crm.tpm.business.audit.invoice.manage.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.constant.AuditInvoiceManageConstant;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageItemExportVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 发票管理明细导出
 * @author hdy
 */
@Component
@Slf4j
public class AuditInvoiceManageItemExportProcess implements ExportProcess<AuditInvoiceManageItemExportVo> {

    @Autowired(required = false)
    private AuditInvoiceManageService auditInvoiceManageService;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        Pageable pageable = PageRequest.of(1, 1);
        AuditInvoiceManageDto dto = convertParams(params);
        Page<AuditInvoiceManageItemExportVo> pageResult = this.auditInvoiceManageService.findAllConditions(pageable, dto);
        Validate.isTrue(pageResult.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    @Override
    public Class<AuditInvoiceManageItemExportVo> findCrmExcelVoClass() {
        return AuditInvoiceManageItemExportVo.class;
    }
    /**
     * 获取
     * @param params
     * @return
     */
    private AuditInvoiceManageDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        return JSON.parseObject(JSON.toJSONString(params), AuditInvoiceManageDto.class);
    }

    @Override
    @Transactional(readOnly = true)
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      发票管理明细导出[{}]    <=====", JSON.toJSONString(vo));
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, getPageSize());
        AuditInvoiceManageDto dto = convertParams(params);
        Page<AuditInvoiceManageItemExportVo> pageResult = this.auditInvoiceManageService.findAllConditions(pageable, dto);
        if (CollectionUtils.isEmpty(pageResult.getRecords())) {
            return new JSONArray();
        }
        List<AuditInvoiceManageItemExportVo> records = pageResult.getRecords();
        adjustData(records);
        //TODO 按照配置导出字段过滤
        return JSON.parseArray(JSON.toJSONString(records, SerializerFeature.WriteDateUseDateFormat));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_INVOICE_MANAGE_ITEM_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM发票管理明细导出";
    }
    /**
     * 调整数据
     *
     * @param data
     */
    private void adjustData(Collection<AuditInvoiceManageItemExportVo> data) {
        //  转换数据字典值
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(AuditInvoiceManageConstant.TPM_AUDIT_INVOICE_TYPE,
                AuditInvoiceManageConstant.MDM_BUSINESS_FORMAT,
                AuditInvoiceManageConstant.MDM_BUSINESS_UNIT));
        for (AuditInvoiceManageItemExportVo vo : data) {
            vo.setInvoiceType(this.findDictValue(mapDict, AuditInvoiceManageConstant.TPM_AUDIT_INVOICE_TYPE, String.valueOf(vo.getInvoiceType())));
            vo.setBusinessFormatCode(this.findDictValue(mapDict, AuditInvoiceManageConstant.MDM_BUSINESS_FORMAT, String.valueOf(vo.getBusinessFormatCode())));
            vo.setBusinessUnitCode(this.findDictValue(mapDict, AuditInvoiceManageConstant.MDM_BUSINESS_UNIT, String.valueOf(vo.getBusinessUnitCode())));
        }
    }
    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream()
                        .filter(a -> a.getDictCode().equals(code))
                        .map(DictDataVo::getDictValue)
                        .findFirst();
        return first.orElse(StringUtils.EMPTY);
    }
}
