package com.biz.crm.tpm.business.audit.invoice.manage.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.invoice.manage.local.entity.AuditInvoiceManage;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceAuditDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceAuditVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageItemExportVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/12 17:52
 * @description: 结案核销-发票管理表(AuditInvoice)表mybatis访问层
 */
public interface AuditInvoiceManageMapper extends BaseMapper<AuditInvoiceManage> {

    /**
     * 分页查询所有数据
     *
     * @param page                  分页对象
     * @param auditInvoiceManageDto 查询Dto
     * @return 所有数据
     */
    Page<AuditInvoiceManageVo> findByConditions(@Param("page") Page<AuditInvoiceManageVo> page, @Param("dto") AuditInvoiceManageDto auditInvoiceManageDto);

    /**
     * 分页查询关联核销明细
     *
     * @param page 分页对象
     * @param dto  查询Dto
     * @return 所有数据
     */
    Page<AuditInvoiceAuditVo> findAuditByConditions(@Param("page") Page<AuditInvoiceAuditVo> page, @Param("dto") AuditInvoiceAuditDto dto);

    /**
     * 分页查询有可用余额的数据(结案核销选择发票使用)
     *
     * @param page                  分页对象
     * @param auditInvoiceManageDto 查询Dto
     * @return 所有数据
     */
    Page<AuditInvoiceManageVo> findBalanceByConditions(@Param("page") Page<AuditInvoiceManageVo> page, @Param("dto") AuditInvoiceManageDto auditInvoiceManageDto);


    /**
     * 根据编码查询发票明细
     *
     * @return
     */
    List<AuditInvoiceItemVo> findByInvoiceNoCode(@Param("dtos") List<AuditInvoiceManageDto> auditInvoiceManageDtos);

    /**
     *
     * @param auditInvoiceManageDtos
     * @return
     */
    List<AuditInvoiceManage> findByCodeAndNo(@Param("dtos") List<AuditInvoiceManageDto> auditInvoiceManageDtos);

    List<AuditInvoiceItemVo> findInvoiceItem(@Param("invoiceCode") String invoiceCode,@Param("invoiceNumber") String invoiceNumber);

    /**
     * 条件查询发票明细信息导出
     *
     * @param page
     * @param dto
     * @return
     */
    Page<AuditInvoiceManageItemExportVo> findAllConditions(@Param("page") Page<AuditInvoiceManageItemExportVo> page,@Param("dto") AuditInvoiceManageDto dto);

    /**
     * 更新发票使用状态
     * @param invoiceManageDtoList
     * @param isUse
     * @param useDate
     */
    void updateByNoAndCode(@Param("invoiceManageDtoList") List<AuditInvoiceManageDto> invoiceManageDtoList,@Param("isUse") String isUse,@Param("useDate") String useDate);

    Page<AuditInvoiceAuditVo> findForAuditHandleByInvoiceCrmCode(@Param("page") Page<AuditInvoiceAuditVo> page,@Param("invoiceCrmCode") String invoiceCrmCode);

}
