package com.biz.crm.tpm.business.audit.invoice.manage.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/11/8 16:57
 * @description: 结案核销-发票管理数据视图
 */
@Component
@Slf4j
public class AuditInvoiceManageDataviewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_audit_invoice_manage_data_view";
    }

    @Override
    public String desc() {
        return "TPM-结案核销-发票管理";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_audit_invoice_manage t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
