package com.biz.crm.tpm.business.audit.invoice.manage.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.invoice.manage.local.entity.AuditInvoiceManageFile;
import com.biz.crm.tpm.business.audit.invoice.manage.local.mapper.AuditInvoiceManageFileMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * @author: chenlong
 * @date: 2023/3/24 10:17
 * @description: 结案核销-发票管理-发票文件表(AuditInvoiceManageFile)表数据库访问层
 */
@Component
public class AuditInvoiceManageFileRepository extends ServiceImpl<AuditInvoiceManageFileMapper, AuditInvoiceManageFile> {

    @Autowired(required = false)
    private AuditInvoiceManageFileMapper auditInvoiceManageFileMapper;


    /**
     * 删除附件
     *
     * @param crmCodes 编码集合
     */
    public void delFile(List<String> crmCodes) {
        if (CollectionUtils.isEmpty(crmCodes)) {
            return;
        }
        LambdaQueryWrapper<AuditInvoiceManageFile> wrapper = new LambdaQueryWrapper<AuditInvoiceManageFile>()
                .eq(AuditInvoiceManageFile::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(AuditInvoiceManageFile::getInvoiceCrmCode, crmCodes)
                .eq(AuditInvoiceManageFile::getTenantCode, TenantUtils.getTenantCode());
        this.remove(wrapper);
    }

    public List<AuditInvoiceManageFile> findByInvoiceCrmCode(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        return lambdaQuery()
                .in(AuditInvoiceManageFile::getInvoiceCrmCode, codes)
                .eq(AuditInvoiceManageFile::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditInvoiceManageFile::getTenantCode,TenantUtils.getTenantCode())
                .orderByDesc(AuditInvoiceManageFile::getCreateTime)
                .list();
    }
}
