package com.biz.crm.tpm.business.audit.invoice.manage.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.invoice.manage.local.entity.AuditInvoiceManageItem;
import com.biz.crm.tpm.business.audit.invoice.manage.local.mapper.AuditInvoiceManageItemMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/3/10 15:05
 * @description: 结案核销-发票管理行明细表(AuditInvoiceManageItem)表数据库访问层
 */
@Component
public class AuditInvoiceManageItemRepository extends ServiceImpl<AuditInvoiceManageItemMapper, AuditInvoiceManageItem> {

    @Autowired(required = false)
    private AuditInvoiceManageItemMapper auditInvoiceManageItemMapper;

    /**
     * 删除明细
     *
     * @param crmCodes 编码集合
     */
    public void delItem(List<String> crmCodes) {
        if (CollectionUtils.isEmpty(crmCodes)) {
            return;
        }
        LambdaQueryWrapper<AuditInvoiceManageItem> wrapper = new LambdaQueryWrapper<AuditInvoiceManageItem>()
                .eq(AuditInvoiceManageItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(AuditInvoiceManageItem::getInvoiceCrmCode, crmCodes)
                .eq(AuditInvoiceManageItem::getTenantCode, TenantUtils.getTenantCode());
        this.remove(wrapper);
    }
}
