package com.biz.crm.tpm.business.audit.invoice.manage.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.invoice.manage.local.entity.AuditInvoiceManage;
import com.biz.crm.tpm.business.audit.invoice.manage.local.mapper.AuditInvoiceManageMapper;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceAuditDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceAuditVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageItemExportVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceManageVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/12 17:53
 * @description: 结案核销-发票管理表(AuditInvoice)表数据库访问层
 */
@Component
public class AuditInvoiceManageRepository extends ServiceImpl<AuditInvoiceManageMapper, AuditInvoiceManage> {

    @Autowired(required = false)
    private AuditInvoiceManageMapper auditInvoiceManageMapper;

    /**
     * 重构修改方法
     *
     * @param entity     实体类
     * @param tenantCode 租户编码
     */
    public void updateByIdAndTenantCode(AuditInvoiceManage entity, String tenantCode) {
        if (null == entity) {
            return;
        }
        if (StringUtils.isEmpty(tenantCode) || StringUtils.isEmpty(entity.getId())) {
            return;
        }
        LambdaUpdateWrapper<AuditInvoiceManage> lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(AuditInvoiceManage::getTenantCode, tenantCode);
        lambdaUpdateWrapper.eq(AuditInvoiceManage::getId, entity.getId());
        this.baseMapper.update(entity, lambdaUpdateWrapper);
    }


    /**
     * 分页查询数据
     *
     * @param pageable              分页对象
     * @param auditInvoiceManageDto 查询Dto
     * @return Page<AuditInvoiceManageVo>
     */
    public Page<AuditInvoiceManageVo> findByConditions(Pageable pageable, AuditInvoiceManageDto auditInvoiceManageDto) {
        Page<AuditInvoiceManageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());

        return this.auditInvoiceManageMapper.findByConditions(page, auditInvoiceManageDto);
    }


    /**
     * 分页查询关联核销明细
     *
     * @param pageable 分页对象
     * @param dto      查询Dto
     * @return Page<AuditInvoiceAuditVo>
     */
    public Page<AuditInvoiceAuditVo> findAuditByConditions(Pageable pageable, AuditInvoiceAuditDto dto) {
        Page<AuditInvoiceAuditVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditInvoiceManageMapper.findAuditByConditions(page, dto);
    }

    /**
     * 分页查询有可用余额的数据(结案核销选择发票使用)
     *
     * @param pageable              分页对象
     * @param auditInvoiceManageDto 查询Dto
     * @return Page<AuditInvoiceManageVo>
     */
    public Page<AuditInvoiceManageVo> findBalanceByConditions(Pageable pageable, AuditInvoiceManageDto auditInvoiceManageDto) {
        Page<AuditInvoiceManageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditInvoiceManageMapper.findBalanceByConditions(page, auditInvoiceManageDto);
    }

    /**
     * 根据编码查询发票明细
     *
     * @return
     */
    public List<AuditInvoiceItemVo> findByInvoiceNoCode(List<AuditInvoiceManageDto> auditInvoiceManageDtos) {
        if(CollectionUtils.isEmpty(auditInvoiceManageDtos)){
            return Lists.newArrayList();
        }
        return this.auditInvoiceManageMapper.findByInvoiceNoCode(auditInvoiceManageDtos);
    }

    /**
     * 根据发票号码和发票代码查询
     * @param auditInvoiceManageDtos
     * @return
     */
    public List<AuditInvoiceManage> findByCodeAndNo(List<AuditInvoiceManageDto> auditInvoiceManageDtos) {
        if(CollectionUtils.isEmpty(auditInvoiceManageDtos)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findByCodeAndNo(auditInvoiceManageDtos);
    }

    public List<AuditInvoiceItemVo> findInvoiceItem(String invoiceCode, String invoiceNumber) {
        return this.auditInvoiceManageMapper.findInvoiceItem(invoiceCode,invoiceNumber);
    }

    public Page<AuditInvoiceManageItemExportVo> findAllConditions(Pageable pageable, AuditInvoiceManageDto dto) {
        Page<AuditInvoiceManageItemExportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return auditInvoiceManageMapper.findAllConditions(page,dto);
    }

    /**
     * 更新发票使用状态
     *
     * @param invoiceManageDtoList
     */
    public void updateByNoAndCode(List<AuditInvoiceManageDto> invoiceManageDtoList,String isUse,String useDate) {
        auditInvoiceManageMapper.updateByNoAndCode(invoiceManageDtoList,isUse,useDate);
    }

    public Page<AuditInvoiceAuditVo> findForAuditHandleByInvoiceCrmCode(Pageable pageable, String invoiceCrmCode) {
        Page<AuditInvoiceAuditVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditInvoiceManageMapper.findForAuditHandleByInvoiceCrmCode(page, invoiceCrmCode);
    }
}
