package com.biz.crm.tpm.business.audit.invoice.manage.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mn.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.invoice.identify.sdk.dto.InvoiceIdentifyCheckDto;
import com.biz.crm.mn.third.system.invoice.identify.sdk.dto.InvoiceIdentifyIdentifyDto;
import com.biz.crm.mn.third.system.invoice.identify.sdk.dto.InvoiceIdentifyIdentifyItemDto;
import com.biz.crm.mn.third.system.invoice.identify.sdk.service.InvoiceIdentifyService;
import com.biz.crm.mn.third.system.invoice.identify.sdk.vo.InvoiceCheckItemVo;
import com.biz.crm.mn.third.system.invoice.identify.sdk.vo.InvoiceIdentifyCheckVo;
import com.biz.crm.mn.third.system.invoice.identify.sdk.vo.InvoiceIdentifyIdentifyVo;
import com.biz.crm.tpm.business.audit.invoice.manage.local.bean.AuditInvoiceManageMsgBean;
import com.biz.crm.tpm.business.audit.invoice.manage.local.entity.AuditInvoiceManage;
import com.biz.crm.tpm.business.audit.invoice.manage.local.entity.AuditInvoiceManageFile;
import com.biz.crm.tpm.business.audit.invoice.manage.local.entity.AuditInvoiceManageItem;
import com.biz.crm.tpm.business.audit.invoice.manage.local.repository.AuditInvoiceManageFileRepository;
import com.biz.crm.tpm.business.audit.invoice.manage.local.repository.AuditInvoiceManageItemRepository;
import com.biz.crm.tpm.business.audit.invoice.manage.local.repository.AuditInvoiceManageRepository;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.constant.AuditInvoiceManageConstant;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.*;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.enums.InvoiceCheckTypeEnum;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.enums.InvoiceTypeEnum;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.event.log.AuditInvoiceManageEventListener;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.*;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * @author: chenlong
 * @date: 2022/11/12 17:56
 * @description: 结案核销-发票管理表(AuditInvoice)表服务实现类
 */
@Service("auditInvoiceManageService")
@Slf4j
public class AuditInvoiceManageServiceImpl implements AuditInvoiceManageService {

    @Autowired
    private AuditInvoiceManageRepository auditInvoiceManageRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private FileHandleService fileHandleService;
    @Autowired
    private InvoiceIdentifyService invoiceIdentifyService;
    @Autowired(required = false)
    private RedisLockService redisLockService;
    @Autowired(required = false)
    private AuditInvoiceManageItemRepository auditInvoiceManageItemRepository;
    @Autowired(required = false)
    private AuditInvoiceManageFileRepository auditInvoiceManageFileRepository;
    @Autowired(required = false)
    private AuditInvoiceManageMsgBean auditInvoiceManageMsgBean;
    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 分页查询所有数据
     *
     * @param pageable              分页对象
     * @param auditInvoiceManageDto 查询dto
     * @return 所有数据
     */
    @Override
    public Page<AuditInvoiceManageVo> findByConditions(Pageable pageable, AuditInvoiceManageDto auditInvoiceManageDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(auditInvoiceManageDto)) {
            auditInvoiceManageDto = new AuditInvoiceManageDto();
        }
        auditInvoiceManageDto.setTenantCode(TenantUtils.getTenantCode());
        Page<AuditInvoiceManageVo> invoiceManageVoPage = this.auditInvoiceManageRepository.findByConditions(pageable, auditInvoiceManageDto);
        List<AuditInvoiceManageVo> records = invoiceManageVoPage.getRecords();
        fillData(records);
        return invoiceManageVoPage;
    }

    private void fillData(List<AuditInvoiceManageVo> records) {
        if(!CollectionUtils.isEmpty(records)){
            AuditInvoiceEventDto invoiceEventDto = new AuditInvoiceEventDto();
            for (AuditInvoiceManageVo record : records) {
                AuditInvoiceEventDto.Item eventItemDto = new AuditInvoiceEventDto.Item();
                eventItemDto.setInvoiceNo(record.getInvoiceNo());
                eventItemDto.setInvoiceCode(record.getInvoiceCode());
                invoiceEventDto.getItems().add(eventItemDto);
                record.setTaxRate(record.getTax());
            }

//            SerializableBiConsumer<AuditInvoiceEventListenter, AuditInvoiceEventDto> findAuditInvoiceByInvoice =
//                    AuditInvoiceEventListenter::findAuditInvoiceByInvoice;
//            AuditInvoiceResponseVo invoiceResponseVo = (AuditInvoiceResponseVo) this.nebulaNetEventClient.directPublish(invoiceEventDto,
//                    AuditInvoiceEventListenter.class, findAuditInvoiceByInvoice);
//            Map<String, AuditInvoiceResponseVo.Item> itemMap = new HashMap<>();
//            if(!CollectionUtils.isEmpty(invoiceResponseVo.getItems())){
//                itemMap = invoiceResponseVo.getItems().stream().collect(Collectors.toMap(o -> o.getInvoiceNo() + o.getInvoiceCode(), Function.identity(), (o, n) -> o));
//            }
//            log.info("查询发票返回：invoiceResponseVo：{}", JsonUtils.obj2JsonString(invoiceResponseVo));
//            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
//            for (AuditInvoiceManageVo record : records) {
//                AuditInvoiceResponseVo.Item item = itemMap.get(record.getInvoiceNo() + record.getInvoiceCode());
//                if(Objects.nonNull(item)){
//                    record.setIsUse("是");
//                    record.setUseYears(df.format(item.getCreateTime()));
//                }else {
//                    record.setIsUse(null);
//                    record.setUseYears(null);
//                }
//            }
        }
    }

    /**
     * 分页查询有可用余额的数据(结案核销选择发票使用)
     *
     * @param pageable              分页对象
     * @param auditInvoiceManageDto 查询dto
     * @return 所有数据
     */
    @Override
    public Page<AuditInvoiceManageVo> findBalanceByConditions(Pageable pageable, AuditInvoiceManageDto auditInvoiceManageDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(auditInvoiceManageDto)) {
            auditInvoiceManageDto = new AuditInvoiceManageDto();
        }
        return this.auditInvoiceManageRepository.findBalanceByConditions(pageable, auditInvoiceManageDto);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public AuditInvoiceManageVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        AuditInvoiceManage invoice = this.auditInvoiceManageRepository.getById(id);
        if (null == invoice) {
            return null;
        }
        AuditInvoiceManageVo manageVo = this.nebulaToolkitService.copyObjectByWhiteList(invoice, AuditInvoiceManageVo.class, null, null);
        List<AuditInvoiceManageItem> itemList = this.auditInvoiceManageItemRepository.lambdaQuery()
                .eq(AuditInvoiceManageItem::getInvoiceNo, invoice.getInvoiceNo())
                .eq(AuditInvoiceManageItem::getInvoiceCrmCode, invoice.getInvoiceCrmCode())
                .eq(AuditInvoiceManageItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if (!CollectionUtils.isEmpty(itemList)) {
            Collection<AuditInvoiceManageItemVo> itemVoList = this.nebulaToolkitService.copyCollectionByWhiteList(itemList, AuditInvoiceManageItem.class, AuditInvoiceManageItemVo.class, HashSet.class, ArrayList.class);
            manageVo.setLineList((List<AuditInvoiceManageItemVo>) itemVoList);
        }
        AuditInvoiceManageFile file = this.auditInvoiceManageFileRepository.lambdaQuery()
                .eq(AuditInvoiceManageFile::getInvoiceNo, invoice.getInvoiceNo())
                .eq(AuditInvoiceManageFile::getInvoiceCrmCode, invoice.getInvoiceCrmCode())
                .eq(AuditInvoiceManageFile::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
        if (!Objects.isNull(file)) {
            AuditInvoiceManageFileVo fileVo = this.nebulaToolkitService.copyObjectByWhiteList(file, AuditInvoiceManageFileVo.class, HashSet.class, ArrayList.class);
            manageVo.setFile(fileVo);
        }
        return manageVo;
    }

    /**
     * 新增数据
     *
     * @param auditInvoiceManageDto dto对象
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<AuditInvoiceManageVo> create(AuditInvoiceManageDto auditInvoiceManageDto) {
        this.createValidate(auditInvoiceManageDto);
        Validate.isTrue(auditInvoiceManageDto.getInvoiceFileUrl().size() <= 10, "新增时，最多只能上传10个附件！");
        FacturerUserDetails identity = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String account = null;
        if (!Objects.isNull(identity)) {
            account = identity.getAccount();
        }
        String orgCode = identity.getOrgCode();
        String orgName = identity.getOrgName();

        //识别参数dto
        InvoiceIdentifyIdentifyDto identifyDto = new InvoiceIdentifyIdentifyDto();
        List<InvoiceIdentifyIdentifyItemDto> fileList = new ArrayList<>();
        //文件编码集合
        List<String> fileCodes = new LinkedList<>();
        //从文件服务获取发票文件，组装识别参数，并记录文件编码顺序
        Set<String> prefix = new HashSet<>();
        prefix.add("jpg");
        prefix.add("jpeg");
        prefix.add("png");
        for (AuditInvoiceManageFileDto fileDto : auditInvoiceManageDto.getInvoiceFileUrl()) {
            byte[] fileBytes = fileHandleService.findContentByFilePathAndFileRename(fileDto.getRelativeLocal(), fileDto.getFileName());
            if (prefix.contains(fileDto.getPrefix().toLowerCase())) {
                log.error("{}文件长度byte{}", fileDto.getOriginalFileName(), fileBytes.length);
                try {
                    //图片所在路径
                    BufferedImage templateImage = ImageIO.read(new ByteArrayInputStream(fileBytes));
                    //原始图片的长度和宽度
                    int height = templateImage.getHeight();
                    int width = templateImage.getWidth();

                    //通过比例压缩
                    float scale = 0.5f;

                    //通过固定长度压缩
                    /*int doWithHeight = 100;
                    int dowithWidth = 300;*/

                    //压缩之后的长度和宽度
                    int doWithHeight = (int) (scale * height);
                    int dowithWidth = (int) (scale * width);

                    BufferedImage finalImage = new BufferedImage(dowithWidth, doWithHeight, BufferedImage.TYPE_INT_RGB);

                    finalImage.getGraphics().drawImage(templateImage.getScaledInstance(dowithWidth, doWithHeight, java.awt.Image.SCALE_SMOOTH), 0, 0, null);
                    ByteArrayOutputStream ou = new ByteArrayOutputStream();
                    ImageIO.write(finalImage, fileDto.getPrefix(), ou);

                    fileBytes = ou.toByteArray();
                    log.error("{}文件压缩后长度byte{}", fileDto.getOriginalFileName(), fileBytes.length);
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            InvoiceIdentifyIdentifyItemDto itemDto = new InvoiceIdentifyIdentifyItemDto();
            itemDto.setFileName(fileDto.getFileName());
            itemDto.setFileContent(Base64.encodeBase64String(fileBytes));
            fileList.add(itemDto);
            fileCodes.add(fileDto.getFileCode());
            this.auditInvoiceManageMsgBean.sendProcessMsg(fileDto.getFileCode(), fileDto.getOriginalFileName(), InvoiceCheckTypeEnum.IDENTIFYING, null, account);
        }
        //发票文件map
        Map<String, AuditInvoiceManageFileDto> fileDtoMap = auditInvoiceManageDto.getInvoiceFileUrl().stream().collect(
                Collectors.toMap(AuditInvoiceManageFileDto::getFileCode, Function.identity()));

        //发票号码列表，批量加锁使用
        List<String> fphm = new ArrayList<>();
        //循环校验识别结果，并默认识别结果顺序与入参文件顺序一致，用来匹配文件和识别结果
        Map<String, String> sortMap = new HashMap<>();
        List<InvoiceIdentifyIdentifyVo> identifyVoList2 = new ArrayList<>();
        int k = 0;
        for (InvoiceIdentifyIdentifyItemDto itemDto : fileList) {
            try {
                List<InvoiceIdentifyIdentifyItemDto> group = new ArrayList<>();
                group.add(itemDto);
                identifyDto.setFjjh(group);
                //先识别发票
                List<InvoiceIdentifyIdentifyVo> identifyVoList = invoiceIdentifyService.identifyInvoice(identifyDto);
                //识别结果初校验
                Validate.notEmpty(identifyVoList, "发票识别异常,未能获取到OCR返回结果，请联系管理员");

                InvoiceIdentifyIdentifyVo identifyVo = identifyVoList.get(0);
                Validate.notNull(identifyVo, "发票识别异常");
                Validate.notBlank(identifyVo.getFphm(), "未能识别出发票号码");
                Validate.notBlank(identifyVo.getFplx(), "未能识别出发票类型");
                Validate.notBlank(identifyVo.getKprq(), "未能识别出发票开票日期");
                Validate.notBlank(identifyVo.getHjje(), "未能识别出发票合计金额");
                //校验码，普票、电子普票、卷式普票必填；取值来源：发票上面校验码后 6位数字
                if (InvoiceTypeEnum.VAT_INVOICE.getCode().equals(identifyVo.getFplx()) || InvoiceTypeEnum.VATE_INVOICE.getCode().equals(identifyVo.getFplx())
                        || InvoiceTypeEnum.COIL_INVOICE.getCode().equals(identifyVo.getFplx())) {
                    if (StringUtils.isBlank(identifyVo.getJym())) {
                        //若没有校验码，在尝试从备注里获取，因河南的发票校验码放在备注里的
                        Validate.notBlank(identifyVo.getBzbz(), "未能识别出发票校验码");
                        if (identifyVo.getBzbz().startsWith("校验码")) {
                            identifyVo.setJym(identifyVo.getBzbz().substring(3));
                        } else {
                            Validate.isTrue(false, "未能识别出发票校验码");
                        }
                    }
                }

                fphm.add(getInvoiceUniqueKey(identifyVo.getFpdm(),identifyVo.getFphm()));
                if (sortMap.containsKey(getInvoiceUniqueKey(identifyVo.getFpdm(),identifyVo.getFphm()))) {
                    this.auditInvoiceManageMsgBean.sendProcessMsg(fileCodes.get(k), fileDtoMap.get(fileCodes.get(k)).getOriginalFileName(), InvoiceCheckTypeEnum.DUPLICATE_INVOICE_UPLOAD, null, account);
                } else {
                    sortMap.put(getInvoiceUniqueKey(identifyVo.getFpdm(),identifyVo.getFphm()), fileCodes.get(k));
                    this.auditInvoiceManageMsgBean.sendProcessMsg(fileCodes.get(k), fileDtoMap.get(fileCodes.get(k)).getOriginalFileName(), InvoiceCheckTypeEnum.VERIFY_TRUTH, null, account);
                    identifyVoList2.add(identifyVo);
                }
                k++;
            } catch (Exception e) {
                log.error("", e);
                this.auditInvoiceManageMsgBean.sendProcessMsg(fileCodes.get(k), fileDtoMap.get(fileCodes.get(k)).getOriginalFileName(), InvoiceCheckTypeEnum.FAIL_IDENTIFY, e.getMessage(), account);
                k++;
            }
        }
        //加锁
        boolean hasLock = false;
        try {
            hasLock = redisLockService.batchLock(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK, fphm, TimeUnit.MINUTES, 10);
            if (!hasLock) {
                throw new RuntimeException("发票上传中，请勿重复操作");
            }
            //判断数据重复
            Set<String> hmSet = new HashSet<>();
            List<AuditInvoiceManageDto> auditInvoiceManageDtos = new ArrayList<>();
            for (InvoiceIdentifyIdentifyVo vo : identifyVoList2) {
                AuditInvoiceManageDto auditInvoiceManageDto1 = new AuditInvoiceManageDto();
                auditInvoiceManageDto1.setInvoiceCode(vo.getFpdm());
                auditInvoiceManageDto1.setInvoiceNo(vo.getFphm());
                auditInvoiceManageDtos.add(auditInvoiceManageDto1);
            }
            List<AuditInvoiceManage> olds = this.auditInvoiceManageRepository.findByCodeAndNo(auditInvoiceManageDtos);
            if (!CollectionUtils.isEmpty(olds)) {
                hmSet = olds.stream().map(o->getInvoiceUniqueKey(o.getInvoiceCode(),o.getInvoiceNo())).collect(Collectors.toSet());
//                throw new RuntimeException("已存在此发票号码[" + hmSet + "]，请勿重复添加");
            }
            //验真结果List
            List<InvoiceIdentifyCheckVo> checkVoList = new ArrayList<>();
            //循环识别结果，进行发票验真
            Set<String> cfSet = new HashSet<>();
            for (InvoiceIdentifyIdentifyVo vo : identifyVoList2) {
                try {
                    if (hmSet.contains(getInvoiceUniqueKey(vo.getFpdm(),vo.getFphm()))) {
                        String fileCode = sortMap.get(getInvoiceUniqueKey(vo.getFpdm(),vo.getFphm()));
                        this.auditInvoiceManageMsgBean.sendProcessMsg(fileCode, fileDtoMap.get(fileCode).getOriginalFileName(), InvoiceCheckTypeEnum.ALREADY_EXISTS, null, account);
                        continue;
                    }
                    //在验真发票
                    InvoiceIdentifyCheckDto checkDto = new InvoiceIdentifyCheckDto();
                    checkDto.setFphm(vo.getFphm());
                    //发票代码，全电票不需要传此节点
                    checkDto.setFpdm(vo.getFpdm());
                    checkDto.setFplx(vo.getFplx());
                    //校验码，普票、电子普票、卷式普票必填；取值来源：发票上面校验码后 6位数字
                    if (StringUtils.isNotBlank(vo.getJym())) {
                        //校验码取后6位
                        int i = vo.getJym().length();
                        Validate.isTrue(i >= 6, "未能识别出发票校验码");
                        checkDto.setJym(vo.getJym().substring(i - 6, i));
                    }

                    checkDto.setKprqStr(vo.getKprq());
                    //除全电票以外的发票传不含税金额；全电票需要传入含税金额；
                    if (InvoiceTypeEnum.E_VAT_INVOICE.getCode().equals(checkDto.getFplx()) || InvoiceTypeEnum.E_VATS_INVOICE.getCode().equals(checkDto.getFplx())) {
                        checkDto.setHjje(vo.getJshj());
                    } else {
                        checkDto.setHjje(vo.getHjje());
                    }

                    InvoiceIdentifyCheckVo checkVo = invoiceIdentifyService.checkInvoice(checkDto);
                    Validate.notNull(checkVo, "发票验真异常");
                    checkVoList.add(checkVo);

                    String fileCode = sortMap.get(getInvoiceUniqueKey(checkVo.getFpdm(),checkVo.getFphm()));
                    this.auditInvoiceManageMsgBean.sendProcessMsg(fileCode, fileDtoMap.get(fileCode).getOriginalFileName(), InvoiceCheckTypeEnum.SUCCESS_VERIFY_TRUTH, null, account, ExecStatusEnum.FINISH.getDictCode());
                } catch (Exception e) {
                    log.error("", e);
                    String fileCode = sortMap.get(getInvoiceUniqueKey(vo.getFpdm(),vo.getFphm()));
                    this.auditInvoiceManageMsgBean.sendProcessMsg(fileCode, fileDtoMap.get(fileCode).getOriginalFileName(), InvoiceCheckTypeEnum.FAIL_VERIFY_TRUTH, null, account);
                }
            }
            if (CollectionUtils.isEmpty(checkVoList)) {
                return Lists.newArrayList();
            }

            //开始组装保存参数
            //批量获取编码
//            String ruleCode = StringUtils.join(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
            List<String> codes = this.generateCodeService.generateCode(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_PREFIX, checkVoList.size(), 5, 2, TimeUnit.DAYS);
            //发票头信息列表
            List<AuditInvoiceManageDto> manageDtos = new ArrayList<>();
            //发票文件列表
            List<AuditInvoiceManageFileDto> fileDtos = new ArrayList<>();
            //发票明细列表
            List<AuditInvoiceManageItem> itemList = new ArrayList<>();
            //循环验真结果，组装保存数据
            for (int i = 0; i < checkVoList.size(); i++) {
                InvoiceIdentifyCheckVo checkVo = checkVoList.get(i);
                AuditInvoiceManageDto manageDto = new AuditInvoiceManageDto();
                manageDto.setBusinessUnitCode(auditInvoiceManageDto.getBusinessUnitCode());
                manageDto.setBusinessFormatCode(auditInvoiceManageDto.getBusinessFormatCode());
                manageDto.setSaleOrgCode(auditInvoiceManageDto.getSaleOrgCode());
                manageDto.setSaleOrgName(auditInvoiceManageDto.getSaleOrgName());
                manageDto.setAreaCode(auditInvoiceManageDto.getAreaCode());
                manageDto.setAreaName(auditInvoiceManageDto.getAreaName());
                manageDto.setIsMaterialInvoice(auditInvoiceManageDto.getIsMaterialInvoice());
                manageDto.setIsManual(BooleanEnum.FALSE.getCapital());
                manageDto.setInvoiceCrmCode(codes.get(i));
                manageDto.setTenantCode(TenantUtils.getTenantCode());
                manageDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                manageDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                manageDto.setOrgCode(orgCode);
                manageDto.setOrgName(orgName);

                manageDto.setInvoiceType(checkVo.getFplx());
                manageDto.setInvoiceCode(checkVo.getFpdm());
                manageDto.setInvoiceNo(checkVo.getFphm());
                manageDto.setBillingDate(DateUtil.strToDate(checkVo.getKprqStr(), DateUtil.date_yyyy_MM_dd));
                manageDto.setCheckCode(checkVo.getJym());
                manageDto.setPurchaser(checkVo.getGfmc());
                manageDto.setPNo(checkVo.getGfsh());
                manageDto.setPBankAndAccount(checkVo.getGfkhhzh());
                manageDto.setPAddressAndPhone(checkVo.getGfdzdh());
                manageDto.setSeller(checkVo.getXfmc());
                manageDto.setSNo(checkVo.getXfsh());
                manageDto.setSBankAndAccount(checkVo.getXfkhhzh());
                manageDto.setSAddressAndPhone(checkVo.getXfdzdh());
                manageDto.setPriceAndTax(new BigDecimal(checkVo.getJshj()));
                manageDto.setAmountWithoutTax(new BigDecimal(checkVo.getHjje()));
                manageDto.setTaxAmount(new BigDecimal(checkVo.getHjse()));
                manageDto.setUseAmount(BigDecimal.ZERO);
                manageDto.setAbleAmount(manageDto.getPriceAndTax());
                manageDto.setIsUse(BooleanEnum.FALSE.getCapital());
                manageDtos.add(manageDto);

                String fileCode = sortMap.get(getInvoiceUniqueKey(checkVo.getFpdm(),checkVo.getFphm()));
                AuditInvoiceManageFileDto f = fileDtoMap.get(fileCode);
                f.setInvoiceCrmCode(manageDto.getInvoiceCrmCode());
                f.setInvoiceNo(manageDto.getInvoiceNo());
                fileDtos.add(fileDtoMap.get(fileCode));

                itemList.addAll(this.packageItemDate(checkVo.getFpmxjh(), manageDto.getInvoiceCrmCode(), checkVo.getFphm()));
            }
            //保存数据
            Collection<AuditInvoiceManage> invoices = this.nebulaToolkitService.copyCollectionByWhiteList(manageDtos, AuditInvoiceManageDto.class, AuditInvoiceManage.class, HashSet.class, ArrayList.class);
            this.auditInvoiceManageRepository.saveBatch(invoices);
            this.auditInvoiceManageItemRepository.saveBatch(itemList);
            Collection<AuditInvoiceManageFile> files = this.nebulaToolkitService.copyCollectionByWhiteList(fileDtos, AuditInvoiceManageFileDto.class, AuditInvoiceManageFile.class, HashSet.class, ArrayList.class);
            this.auditInvoiceManageFileRepository.saveBatch(files);
            for (AuditInvoiceManage invoice : invoices) {
                String fileCode = sortMap.get(getInvoiceUniqueKey(invoice.getInvoiceCode(),invoice.getInvoiceNo()));
                this.auditInvoiceManageMsgBean.sendProcessMsg(fileCode, fileDtoMap.get(fileCode).getOriginalFileName(), InvoiceCheckTypeEnum.SUCCESS_SAVE, null, account);
            }

            //新增业务日志
            for (AuditInvoiceManageDto dto : manageDtos) {
                AuditInvoiceManageLogEventDto logEventDto = new AuditInvoiceManageLogEventDto();
                logEventDto.setOriginal(null);
                logEventDto.setNewest(dto);
                SerializableBiConsumer<AuditInvoiceManageEventListener, AuditInvoiceManageLogEventDto> onCreate =
                        AuditInvoiceManageEventListener::onCreate;
                this.nebulaNetEventClient.publish(logEventDto, AuditInvoiceManageEventListener.class, onCreate);
            }
            //将数据返回（这里主要是结案核销那里需要使用返回值）
            List<AuditInvoiceManage> newList = this.auditInvoiceManageRepository.lambdaQuery()
                    .in(AuditInvoiceManage::getInvoiceCrmCode, codes)
                    .eq(AuditInvoiceManage::getTenantCode, TenantUtils.getTenantCode())
                    .eq(AuditInvoiceManage::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .list();
            if (CollectionUtils.isEmpty(newList)) {
                return Lists.newArrayList();
            }
            return (List<AuditInvoiceManageVo>) this.nebulaToolkitService.copyCollectionByWhiteList(newList, AuditInvoiceManage.class, AuditInvoiceManageVo.class, HashSet.class, ArrayList.class);
        } catch (Exception e) {
            log.error("", e);
            throw e;
        } finally {
            if (hasLock) {
                redisLockService.batchUnLock(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK, fphm);
            }
        }
    }

    @Async
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void createAsync(AuditInvoiceManageDto auditInvoiceManageDto, FacturerUserDetails userIdentity) {
        this.createValidate(auditInvoiceManageDto);

        UrlAddressVo mdmUser = new UrlAddressVo();
        mdmUser.setUserName(userIdentity.getAccount());
        mdmUser.setFullName(userIdentity.getRealName());
        String orgCode = userIdentity.getOrgCode();
        String orgName = userIdentity.getOrgName();
        loginUserService.refreshAuthentication(mdmUser);
        AbstractCrmUserIdentity identity = loginUserService.getAbstractLoginUser();
        String account = null;
        if (!Objects.isNull(identity)) {
            account = identity.getAccount();
        }

        //识别参数dto
        InvoiceIdentifyIdentifyDto identifyDto = new InvoiceIdentifyIdentifyDto();
        List<InvoiceIdentifyIdentifyItemDto> fileList = new ArrayList<>();
        //文件编码集合
        List<String> fileCodes = new LinkedList<>();
        //从文件服务获取发票文件，组装识别参数，并记录文件编码顺序
        Set<String> prefix = new HashSet<>();
        prefix.add("jpg");
        prefix.add("jpeg");
        prefix.add("png");
        for (AuditInvoiceManageFileDto fileDto : auditInvoiceManageDto.getInvoiceFileUrl()) {
            byte[] fileBytes = fileHandleService.findContentByFilePathAndFileRename(fileDto.getRelativeLocal(), fileDto.getFileName());
            if (prefix.contains(fileDto.getPrefix().toLowerCase())) {
                log.error("{}文件长度byte{}", fileDto.getOriginalFileName(), fileBytes.length);
                try {
                    //图片所在路径
                    BufferedImage templateImage = ImageIO.read(new ByteArrayInputStream(fileBytes));
                    //原始图片的长度和宽度
                    int height = templateImage.getHeight();
                    int width = templateImage.getWidth();

                    //通过比例压缩
                    float scale = 0.5f;

                    //通过固定长度压缩
                    /*int doWithHeight = 100;
                    int dowithWidth = 300;*/

                    //压缩之后的长度和宽度
                    int doWithHeight = (int) (scale * height);
                    int dowithWidth = (int) (scale * width);

                    BufferedImage finalImage = new BufferedImage(dowithWidth, doWithHeight, BufferedImage.TYPE_INT_RGB);

                    finalImage.getGraphics().drawImage(templateImage.getScaledInstance(dowithWidth, doWithHeight, java.awt.Image.SCALE_SMOOTH), 0, 0, null);
                    ByteArrayOutputStream ou = new ByteArrayOutputStream();
                    ImageIO.write(finalImage, fileDto.getPrefix(), ou);

                    fileBytes = ou.toByteArray();
                    log.error("{}文件压缩后长度byte{}", fileDto.getOriginalFileName(), fileBytes.length);
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            InvoiceIdentifyIdentifyItemDto itemDto = new InvoiceIdentifyIdentifyItemDto();
            itemDto.setFileName(fileDto.getFileName());
            itemDto.setFileContent(Base64.encodeBase64String(fileBytes));
            fileList.add(itemDto);
            fileCodes.add(fileDto.getFileCode());
            this.auditInvoiceManageMsgBean.sendProcessMsg(fileDto.getFileCode(), fileDto.getOriginalFileName(), InvoiceCheckTypeEnum.IDENTIFYING, null, account);
        }
        //发票文件map
        Map<String, AuditInvoiceManageFileDto> fileDtoMap = auditInvoiceManageDto.getInvoiceFileUrl().stream().collect(
                Collectors.toMap(AuditInvoiceManageFileDto::getFileCode, Function.identity()));

        //发票号码列表，批量加锁使用
        List<String> fphm = new ArrayList<>();
        //循环校验识别结果，并默认识别结果顺序与入参文件顺序一致，用来匹配文件和识别结果
        Map<String, String> sortMap = new HashMap<>();
        List<InvoiceIdentifyIdentifyVo> identifyVoList2 = new ArrayList<>();
        int k = 0;
        for (InvoiceIdentifyIdentifyItemDto itemDto : fileList) {
            try {
                List<InvoiceIdentifyIdentifyItemDto> group = new ArrayList<>();
                group.add(itemDto);
                identifyDto.setFjjh(group);
                //先识别发票
                List<InvoiceIdentifyIdentifyVo> identifyVoList = invoiceIdentifyService.identifyInvoice(identifyDto);
                //识别结果初校验
                Validate.notEmpty(identifyVoList, "发票识别异常,未能获取到OCR返回结果，请联系管理员");
//                Validate.isTrue(identifyVoList.size() == group.size(), "发票识别返回结果数量与上传附件数量不一致");

                InvoiceIdentifyIdentifyVo identifyVo = identifyVoList.get(0);
                Validate.notNull(identifyVo, "发票识别异常");
                Validate.notBlank(identifyVo.getFphm(), "未能识别出发票号码");
                Validate.notBlank(identifyVo.getFplx(), "未能识别出发票类型");
                Validate.notBlank(identifyVo.getKprq(), "未能识别出发票开票日期");
                Validate.notBlank(identifyVo.getHjje(), "未能识别出发票合计金额");
                //校验码，普票、电子普票、卷式普票必填；取值来源：发票上面校验码后 6位数字
                if (InvoiceTypeEnum.VAT_INVOICE.getCode().equals(identifyVo.getFplx()) || InvoiceTypeEnum.VATE_INVOICE.getCode().equals(identifyVo.getFplx())
                        || InvoiceTypeEnum.COIL_INVOICE.getCode().equals(identifyVo.getFplx())) {
                    if (StringUtils.isBlank(identifyVo.getJym())) {
                        //若没有校验码，在尝试从备注里获取，因河南的发票校验码放在备注里的
                        Validate.notBlank(identifyVo.getBzbz(), "未能识别出发票校验码");
                        if (identifyVo.getBzbz().startsWith("校验码")) {
                            identifyVo.setJym(identifyVo.getBzbz().substring(3));
                        } else {
                            Validate.isTrue(false, "未能识别出发票校验码");
                        }
                    }
                }

                fphm.add(getInvoiceUniqueKey(identifyVo.getFpdm(),identifyVo.getFphm()));
                if (sortMap.containsKey(getInvoiceUniqueKey(identifyVo.getFpdm(),identifyVo.getFphm()))) {
                    this.auditInvoiceManageMsgBean.sendProcessMsg(fileCodes.get(k), fileDtoMap.get(fileCodes.get(k)).getOriginalFileName(), InvoiceCheckTypeEnum.DUPLICATE_INVOICE_UPLOAD, null, account);
                } else {
                    sortMap.put(getInvoiceUniqueKey(identifyVo.getFpdm(),identifyVo.getFphm()), fileCodes.get(k));
                    this.auditInvoiceManageMsgBean.sendProcessMsg(fileCodes.get(k), fileDtoMap.get(fileCodes.get(k)).getOriginalFileName(), InvoiceCheckTypeEnum.VERIFY_TRUTH, null, account);
                    identifyVoList2.add(identifyVo);
                }
                k++;
            } catch (Exception e) {
                log.error("", e);
                this.auditInvoiceManageMsgBean.sendProcessMsg(fileCodes.get(k), fileDtoMap.get(fileCodes.get(k)).getOriginalFileName(), InvoiceCheckTypeEnum.FAIL_IDENTIFY, e.getMessage(), account);
                k++;
            }
        }
        //加锁
        boolean hasLock = false;
        try {
            hasLock = redisLockService.batchLock(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK, fphm, TimeUnit.MINUTES, 10);
            if (!hasLock) {
                throw new RuntimeException("发票上传中，请勿重复操作");
            }
            //判断数据重复
            Set<String> hmSet = new HashSet<>();
            List<AuditInvoiceManageDto> auditInvoiceManageDtos = new ArrayList<>();
            for (InvoiceIdentifyIdentifyVo vo : identifyVoList2) {
                AuditInvoiceManageDto auditInvoiceManageDto1 = new AuditInvoiceManageDto();
                auditInvoiceManageDto1.setInvoiceCode(vo.getFpdm());
                auditInvoiceManageDto1.setInvoiceNo(vo.getFphm());
                auditInvoiceManageDtos.add(auditInvoiceManageDto1);
            }
            List<AuditInvoiceManage> olds = this.auditInvoiceManageRepository.findByCodeAndNo(auditInvoiceManageDtos);
            if (!CollectionUtils.isEmpty(olds)) {
                hmSet = olds.stream().map(o -> getInvoiceUniqueKey(o.getInvoiceCode(),o.getInvoiceNo())).collect(Collectors.toSet());
            }
            //验真结果List
            List<InvoiceIdentifyCheckVo> checkVoList = new ArrayList<>();
            //循环识别结果，进行发票验真
            Set<String> cfSet = new HashSet<>();
            for (InvoiceIdentifyIdentifyVo vo : identifyVoList2) {
                try {
                    if (hmSet.contains(getInvoiceUniqueKey(vo.getFpdm(),vo.getFphm()))) {
                        String fileCode = sortMap.get(getInvoiceUniqueKey(vo.getFpdm(),vo.getFphm()));
                        this.auditInvoiceManageMsgBean.sendProcessMsg(fileCode, fileDtoMap.get(fileCode).getOriginalFileName(), InvoiceCheckTypeEnum.ALREADY_EXISTS, null, account);
                        continue;
                    }
                    //在验真发票
                    InvoiceIdentifyCheckDto checkDto = new InvoiceIdentifyCheckDto();
                    checkDto.setFphm(vo.getFphm());
                    //发票代码，全电票不需要传此节点
                    checkDto.setFpdm(vo.getFpdm());
                    checkDto.setFplx(vo.getFplx());
                    //校验码，普票、电子普票、卷式普票必填；取值来源：发票上面校验码后 6位数字
                    if (StringUtils.isNotBlank(vo.getJym())) {
                        //校验码取后6位
                        int i = vo.getJym().length();
                        Validate.isTrue(i >= 6, "未能识别出发票校验码");
                        checkDto.setJym(vo.getJym().substring(i - 6, i));
                    }

                    checkDto.setKprqStr(vo.getKprq());
                    //除全电票以外的发票传不含税金额；全电票需要传入含税金额；
                    if (InvoiceTypeEnum.E_VAT_INVOICE.getCode().equals(checkDto.getFplx()) || InvoiceTypeEnum.E_VATS_INVOICE.getCode().equals(checkDto.getFplx())) {
                        checkDto.setHjje(vo.getJshj());
                    } else {
                        checkDto.setHjje(vo.getHjje());
                    }

                    InvoiceIdentifyCheckVo checkVo = invoiceIdentifyService.checkInvoice(checkDto);
                    Validate.notNull(checkVo, "发票验真异常");
                    checkVoList.add(checkVo);

                    String fileCode = sortMap.get(getInvoiceUniqueKey(checkVo.getFpdm(),checkVo.getFphm()));
                    this.auditInvoiceManageMsgBean.sendProcessMsg(fileCode, fileDtoMap.get(fileCode).getOriginalFileName(), InvoiceCheckTypeEnum.SUCCESS_VERIFY_TRUTH, null, account,ExecStatusEnum.FINISH.getDictCode());
                } catch (Exception e) {
                    log.error("", e);
                    String fileCode = sortMap.get(getInvoiceUniqueKey(vo.getFpdm(),vo.getFphm()));
                    this.auditInvoiceManageMsgBean.sendProcessMsg(fileCode, fileDtoMap.get(fileCode).getOriginalFileName(), InvoiceCheckTypeEnum.FAIL_VERIFY_TRUTH, e.getMessage(), account);
                }
            }

            //开始组装保存参数
            //批量获取编码
//            String ruleCode = StringUtils.join(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
            List<String> codes = this.generateCodeService.generateCode(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_PREFIX, checkVoList.size(), 5, 2, TimeUnit.DAYS);
            //发票头信息列表
            List<AuditInvoiceManageDto> manageDtos = new ArrayList<>();
            //发票文件列表
            List<AuditInvoiceManageFileDto> fileDtos = new ArrayList<>();
            //发票明细列表
            List<AuditInvoiceManageItem> itemList = new ArrayList<>();
            //循环验真结果，组装保存数据
            for (int i = 0; i < checkVoList.size(); i++) {
                InvoiceIdentifyCheckVo checkVo = checkVoList.get(i);
                AuditInvoiceManageDto manageDto = new AuditInvoiceManageDto();
                manageDto.setBusinessUnitCode(auditInvoiceManageDto.getBusinessUnitCode());
                manageDto.setBusinessFormatCode(auditInvoiceManageDto.getBusinessFormatCode());
                manageDto.setSaleOrgCode(auditInvoiceManageDto.getSaleOrgCode());
                manageDto.setSaleOrgName(auditInvoiceManageDto.getSaleOrgName());
                manageDto.setAreaCode(auditInvoiceManageDto.getAreaCode());
                manageDto.setAreaName(auditInvoiceManageDto.getAreaName());
                manageDto.setIsMaterialInvoice(auditInvoiceManageDto.getIsMaterialInvoice());
                manageDto.setIsManual(BooleanEnum.FALSE.getCapital());
                manageDto.setInvoiceCrmCode(codes.get(i));
                manageDto.setTenantCode(TenantUtils.getTenantCode());
                manageDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                manageDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                manageDto.setOrgCode(orgCode);
                manageDto.setOrgName(orgName);

                manageDto.setInvoiceType(checkVo.getFplx());
                manageDto.setInvoiceCode(checkVo.getFpdm());
                manageDto.setInvoiceNo(checkVo.getFphm());
                manageDto.setBillingDate(DateUtil.strToDate(checkVo.getKprqStr(), DateUtil.date_yyyy_MM_dd));
                manageDto.setCheckCode(checkVo.getJym());
                manageDto.setPurchaser(checkVo.getGfmc());
                manageDto.setPNo(checkVo.getGfsh());
                manageDto.setPBankAndAccount(checkVo.getGfkhhzh());
                manageDto.setPAddressAndPhone(checkVo.getGfdzdh());
                manageDto.setSeller(checkVo.getXfmc());
                manageDto.setSNo(checkVo.getXfsh());
                manageDto.setSBankAndAccount(checkVo.getXfkhhzh());
                manageDto.setSAddressAndPhone(checkVo.getXfdzdh());
                manageDto.setPriceAndTax(new BigDecimal(checkVo.getJshj()));
                manageDto.setAmountWithoutTax(new BigDecimal(checkVo.getHjje()));
                manageDto.setTaxAmount(new BigDecimal(checkVo.getHjse()));
                manageDto.setUseAmount(BigDecimal.ZERO);
                manageDto.setAbleAmount(manageDto.getPriceAndTax());
                manageDto.setIsUse(BooleanEnum.FALSE.getCapital());
                manageDtos.add(manageDto);

                String fileCode = sortMap.get(getInvoiceUniqueKey(checkVo.getFpdm(),checkVo.getFphm()));
                AuditInvoiceManageFileDto f = fileDtoMap.get(fileCode);
                f.setInvoiceCrmCode(manageDto.getInvoiceCrmCode());
                f.setInvoiceNo(manageDto.getInvoiceNo());
                fileDtos.add(fileDtoMap.get(fileCode));

                itemList.addAll(this.packageItemDate(checkVo.getFpmxjh(), manageDto.getInvoiceCrmCode(), checkVo.getFphm()));
            }
            //保存数据
            Collection<AuditInvoiceManage> invoices = this.nebulaToolkitService.copyCollectionByWhiteList(manageDtos, AuditInvoiceManageDto.class, AuditInvoiceManage.class, HashSet.class, ArrayList.class);
            this.auditInvoiceManageRepository.saveBatch(invoices);
            this.auditInvoiceManageItemRepository.saveBatch(itemList);
            Collection<AuditInvoiceManageFile> files = this.nebulaToolkitService.copyCollectionByWhiteList(fileDtos, AuditInvoiceManageFileDto.class, AuditInvoiceManageFile.class, HashSet.class, ArrayList.class);
            this.auditInvoiceManageFileRepository.saveBatch(files);
            for (AuditInvoiceManage invoice : invoices) {
                String fileCode = sortMap.get(getInvoiceUniqueKey(invoice.getInvoiceCode(),invoice.getInvoiceNo()));
                this.auditInvoiceManageMsgBean.sendProcessMsg(fileCode, fileDtoMap.get(fileCode).getOriginalFileName(), InvoiceCheckTypeEnum.SUCCESS_SAVE, null, account);
            }

            //新增业务日志
            for (AuditInvoiceManageDto dto : manageDtos) {
                AuditInvoiceManageLogEventDto logEventDto = new AuditInvoiceManageLogEventDto();
                logEventDto.setOriginal(null);
                logEventDto.setNewest(dto);
                SerializableBiConsumer<AuditInvoiceManageEventListener, AuditInvoiceManageLogEventDto> onCreate =
                        AuditInvoiceManageEventListener::onCreate;
                this.nebulaNetEventClient.publish(logEventDto, AuditInvoiceManageEventListener.class, onCreate);
            }
        } catch (Exception e) {
            log.error("", e);
            throw e;
        } finally {
            if (hasLock) {
                redisLockService.batchUnLock(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK, fphm);
            }
        }
    }

    private String getInvoiceUniqueKey(String invoiceCode,String invoiceNo){
        String key = null;
        if(StringUtils.isNotEmpty(invoiceCode)){
            key = invoiceCode;
        }
        if(StringUtils.isNotEmpty(invoiceNo)){
            key = key+invoiceNo;
        }
        Validate.notBlank(key,"发票代码发票号码不能同时为空");
        return key;
    }

    /**
     * 手动录入新增数据
     *
     * @param dto dto对象
     */
//    @Transactional(rollbackFor = Exception.class)
    @Override
    public void manualCreate(AuditInvoiceManageDto dto) {
        this.manualCreateValidate(dto);
        FacturerUserDetails identity = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String orgCode = identity.getOrgCode();
        String orgName = identity.getOrgName();
        //加锁
        boolean hasLock = false;
        try {
            String lockKey = AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK + dto.getInvoiceNo();
            if(StringUtils.isNotEmpty(dto.getInvoiceCode())) {
                lockKey = AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK + dto.getInvoiceNo() + dto.getInvoiceCode();
            }
            hasLock = redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 10);
            if (!hasLock) {
                throw new RuntimeException("发票信息录入中，请勿重复操作");
            }
            //判断数据重复
            int count = this.auditInvoiceManageRepository.lambdaQuery()
                    .eq(AuditInvoiceManage::getTenantCode, TenantUtils.getTenantCode())
                    .eq(AuditInvoiceManage::getInvoiceNo, dto.getInvoiceNo())
                    .eq(StringUtils.isNotEmpty(dto.getInvoiceCode()),AuditInvoiceManage::getInvoiceCode,dto.getInvoiceCode())
                    .eq(AuditInvoiceManage::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).count();
            Validate.isTrue(count == 0, "已存在此发票号码，请勿重复添加");

            //在验真发票
            InvoiceIdentifyCheckDto checkDto = new InvoiceIdentifyCheckDto();
            checkDto.setFphm(dto.getInvoiceNo());
            //发票代码，全电票不需要传此节点
            checkDto.setFpdm(dto.getInvoiceCode());
            checkDto.setFplx(dto.getInvoiceType());
            //校验码，普票、电子普票、卷式普票必填；取值来源：发票上面校验码后 6位数字
            if (StringUtils.isNotBlank(dto.getCheckCode())) {
                dto.setCheckCode(dto.getCheckCode().replaceAll(" ", ""));
                int i = dto.getCheckCode().length();
                Validate.isTrue(i >= 6, "发票校验码少于6位，请检查");
                checkDto.setJym(dto.getCheckCode().substring(i - 6, i));
            }

            checkDto.setKprqStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, dto.getBillingDate()));
            //除全电票以外的发票传不含税金额；全电票需要传入含税金额；
            if (InvoiceTypeEnum.E_VAT_INVOICE.getCode().equals(checkDto.getFplx()) || InvoiceTypeEnum.E_VATS_INVOICE.getCode().equals(checkDto.getFplx())) {
                checkDto.setHjje(dto.getPriceAndTax().toString());
            } else {
                checkDto.setHjje(dto.getAmountWithoutTax().toString());
            }
            InvoiceIdentifyCheckVo checkVo = invoiceIdentifyService.checkInvoice(checkDto);
            Validate.notNull(checkVo, "发票验真异常");
            dto.setInvoiceType(checkVo.getFplx());
            dto.setInvoiceCode(checkVo.getFpdm());
            dto.setInvoiceNo(checkVo.getFphm());
            dto.setBillingDate(DateUtil.strToDate(checkVo.getKprqStr(), DateUtil.date_yyyy_MM_dd));
            dto.setCheckCode(checkVo.getJym());
            dto.setPurchaser(checkVo.getGfmc());
            dto.setPNo(checkVo.getGfsh());
            dto.setPBankAndAccount(checkVo.getGfkhhzh());
            dto.setPAddressAndPhone(checkVo.getGfdzdh());
            dto.setSeller(checkVo.getXfmc());
            dto.setSNo(checkVo.getXfsh());
            dto.setSBankAndAccount(checkVo.getXfkhhzh());
            dto.setSAddressAndPhone(checkVo.getXfdzdh());
            dto.setPriceAndTax(new BigDecimal(checkVo.getJshj()));
            dto.setAmountWithoutTax(new BigDecimal(checkVo.getHjje()));
            dto.setTaxAmount(new BigDecimal(checkVo.getHjse()));
            dto.setUseAmount(BigDecimal.ZERO);
            dto.setAbleAmount(dto.getPriceAndTax());
            dto.setOrgName(orgName);
            dto.setOrgCode(orgCode);

            AuditInvoiceManage invoice = nebulaToolkitService.copyObjectByWhiteList(dto, AuditInvoiceManage.class, null, null);

//            String ruleCode = StringUtils.join(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
            String code = this.generateCodeService.generateCode(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_PREFIX, 1, 5, 2, TimeUnit.DAYS).get(0);
            invoice.setInvoiceCrmCode(code);
            invoice.setTenantCode(TenantUtils.getTenantCode());
            invoice.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            invoice.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            invoice.setIsManual(BooleanEnum.TRUE.getCapital());
            this.auditInvoiceManageRepository.save(invoice);

            //保存明细数据
            List<AuditInvoiceManageItem> itemList = this.packageItemDate(checkVo.getFpmxjh(), code, checkVo.getFphm());
            this.auditInvoiceManageItemRepository.saveBatch(itemList);

            //新增业务日志
            AuditInvoiceManageLogEventDto logEventDto = new AuditInvoiceManageLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<AuditInvoiceManageEventListener, AuditInvoiceManageLogEventDto> onCreate =
                    AuditInvoiceManageEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, AuditInvoiceManageEventListener.class, onCreate);
        } catch (Exception e) {
            log.error("", e);
            throw e;
        } finally {
            if (hasLock) {
                redisLockService.unlock(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK + dto.getInvoiceNo());
            }
        }
    }

    /**
     * 手动录入新增数据
     *
     * @param dto dto对象
     */
//    @Transactional(rollbackFor = Exception.class)
    @Override
    public void manualUpdate(AuditInvoiceManageDto dto) {
        this.manualUpdateValidate(dto);
        //加锁
        boolean hasLock = false;
        try {
            String lockKey = AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK + dto.getInvoiceNo();
            if(StringUtils.isNotEmpty(dto.getInvoiceCode())) {
                lockKey = AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK + dto.getInvoiceNo() + dto.getInvoiceCode();
            }
            hasLock = redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 10);
            if (!hasLock) {
                throw new RuntimeException("发票信息录入中，请勿重复操作");
            }
            AuditInvoiceManageVo oldVo = this.findById(dto.getId());
            Validate.isTrue(null == oldVo.getUseAmount() || BigDecimal.ZERO.compareTo(oldVo.getUseAmount()) == 0, "发票已被使用，无法修改");

            Validate.notNull(oldVo, "未查找到发票数据");
            //判断数据重复
            int count = this.auditInvoiceManageRepository.lambdaQuery()
                    .eq(AuditInvoiceManage::getTenantCode, TenantUtils.getTenantCode())
                    .eq(AuditInvoiceManage::getInvoiceNo, dto.getInvoiceNo())
                    .eq(StringUtils.isNotEmpty(dto.getInvoiceCode()),AuditInvoiceManage::getInvoiceCode,dto.getInvoiceCode())
                    .ne(AuditInvoiceManage::getId, dto.getId())
                    .eq(AuditInvoiceManage::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).count();
            Validate.isTrue(count == 0, "已存在此发票号码，请勿重复添加");

            //在验真发票
            InvoiceIdentifyCheckDto checkDto = new InvoiceIdentifyCheckDto();
            checkDto.setFphm(dto.getInvoiceNo());
            //发票代码，全电票不需要传此节点
            checkDto.setFpdm(dto.getInvoiceCode());
            checkDto.setFplx(dto.getInvoiceType());
            ////校验码，普票、电子普票、卷式普票必填；取值来源：发票上面校验码后 6位数字
            if (StringUtils.isNotBlank(dto.getCheckCode())) {
                int i = dto.getCheckCode().length();
                checkDto.setJym(dto.getCheckCode().substring(i - 6, i));
            }
            checkDto.setKprqStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, dto.getBillingDate()));
            //除全电票以外的发票传不含税金额；全电票需要传入含税金额；
            if (InvoiceTypeEnum.E_VAT_INVOICE.getCode().equals(checkDto.getFplx()) || InvoiceTypeEnum.E_VATS_INVOICE.getCode().equals(checkDto.getFplx())) {
                checkDto.setHjje(dto.getPriceAndTax().toString());
            } else {
                checkDto.setHjje(dto.getAmountWithoutTax().toString());
            }
//            checkDto.setHjje(dto.getPriceAndTax().toString());
            InvoiceIdentifyCheckVo checkVo = invoiceIdentifyService.checkInvoice(checkDto);
            Validate.notNull(checkVo, "发票验真异常");

            dto.setInvoiceType(checkVo.getFplx());
            dto.setInvoiceCode(checkVo.getFpdm());
            dto.setInvoiceNo(checkVo.getFphm());
            dto.setBillingDate(DateUtil.strToDate(checkVo.getKprqStr(), DateUtil.date_yyyy_MM_dd));
            dto.setCheckCode(checkVo.getJym());
            dto.setPurchaser(checkVo.getGfmc());
            dto.setPNo(checkVo.getGfsh());
            dto.setPBankAndAccount(checkVo.getGfkhhzh());
            dto.setPAddressAndPhone(checkVo.getGfdzdh());
            dto.setSeller(checkVo.getXfmc());
            dto.setSNo(checkVo.getXfsh());
            dto.setSBankAndAccount(checkVo.getXfkhhzh());
            dto.setSAddressAndPhone(checkVo.getXfdzdh());
            dto.setPriceAndTax(new BigDecimal(checkVo.getJshj()));
            dto.setAmountWithoutTax(new BigDecimal(checkVo.getHjje()));
            dto.setTaxAmount(new BigDecimal(checkVo.getHjse()));
            dto.setUseAmount(BigDecimal.ZERO);
            dto.setAbleAmount(dto.getPriceAndTax());

            AuditInvoiceManage invoice = nebulaToolkitService.copyObjectByWhiteList(dto, AuditInvoiceManage.class, null, null);
            this.auditInvoiceManageRepository.updateByIdAndTenantCode(invoice, TenantUtils.getTenantCode());


            //先删除明细，再保存明细数据
            LambdaQueryWrapper<AuditInvoiceManageItem> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(AuditInvoiceManageItem::getInvoiceCrmCode, oldVo.getInvoiceCrmCode());
            wrapper.eq(AuditInvoiceManageItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
            wrapper.eq(AuditInvoiceManageItem::getInvoiceNo, oldVo.getInvoiceNo());
            this.auditInvoiceManageItemRepository.remove(wrapper);
            List<AuditInvoiceManageItem> itemList = this.packageItemDate(checkVo.getFpmxjh(), dto.getInvoiceCrmCode(), checkVo.getFphm());
            this.auditInvoiceManageItemRepository.saveBatch(itemList);

            //编辑业务日志
            AuditInvoiceManageLogEventDto logEventDto = new AuditInvoiceManageLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<AuditInvoiceManageEventListener, AuditInvoiceManageLogEventDto> onUpdate =
                    AuditInvoiceManageEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, AuditInvoiceManageEventListener.class, onUpdate);
        } catch (Exception e) {
            log.error("", e);
            throw e;
        } finally {
            if (hasLock) {
                redisLockService.unlock(AuditInvoiceManageConstant.AUDIT_INVOICE_MANAGE_LOCK + dto.getInvoiceNo());
            }
        }
    }


    /**
     * 创建验证
     *
     * @param auditInvoiceManageDto dto对象
     */
    private void createValidate(AuditInvoiceManageDto auditInvoiceManageDto) {
        Validate.notNull(auditInvoiceManageDto, "新增时，对象信息不能为空！");
        auditInvoiceManageDto.setId(null);
        Validate.notBlank(auditInvoiceManageDto.getBusinessFormatCode(), "新增时，业态不能为空！");
        Validate.notBlank(auditInvoiceManageDto.getBusinessUnitCode(), "新增时，业务单元不能为空！");
        Validate.notEmpty(auditInvoiceManageDto.getInvoiceFileUrl(), "新增时，附件不能为空！");
    }

    /**
     * 手动录入创建验证
     *
     * @param auditInvoiceManageDto dto对象
     */
    private void manualCreateValidate(AuditInvoiceManageDto auditInvoiceManageDto) {
        Validate.notNull(auditInvoiceManageDto, "新增时，对象信息不能为空！");
        auditInvoiceManageDto.setId(null);
        Validate.notBlank(auditInvoiceManageDto.getBusinessFormatCode(), "新增时，业态不能为空！");
        Validate.notBlank(auditInvoiceManageDto.getBusinessUnitCode(), "新增时，业务单元不能为空！");
        Validate.notBlank(auditInvoiceManageDto.getIsMaterialInvoice(), "新增时，是否实质性发票不能为空！");
        Validate.notBlank(auditInvoiceManageDto.getInvoiceType(), "新增时，发票类型不能为空！");
        //校验码，普票、电子普票、卷式普票必填；取值来源：发票上面校验码后 6位数字
        if (InvoiceTypeEnum.VAT_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType()) ||
                InvoiceTypeEnum.VATE_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType()) ||
                InvoiceTypeEnum.COIL_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType())) {
            Validate.notBlank(auditInvoiceManageDto.getCheckCode(), "新增时，校验码不能为空！");
        }
        //除全电票以外的发票传不含税金额；全电票需要传入含税金额；
        if (InvoiceTypeEnum.E_VAT_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType()) ||
                InvoiceTypeEnum.E_VATS_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType())) {
            Validate.notNull(auditInvoiceManageDto.getPriceAndTax(), "新增时，发票金额(含税)不能为空！");
        } else {
            Validate.notNull(auditInvoiceManageDto.getAmountWithoutTax(), "新增时，发票金额(未税)不能为空！");
        }
    }

    /**
     * 手动录入编辑验证
     *
     * @param auditInvoiceManageDto dto对象
     */
    private void manualUpdateValidate(AuditInvoiceManageDto auditInvoiceManageDto) {
        Validate.notNull(auditInvoiceManageDto, "编辑时，对象信息不能为空！");
        Validate.notBlank(auditInvoiceManageDto.getId(), "编辑时，id不能为空！");
        Validate.notBlank(auditInvoiceManageDto.getBusinessFormatCode(), "编辑时，业态不能为空！");
        Validate.notBlank(auditInvoiceManageDto.getBusinessUnitCode(), "编辑时，业务单元不能为空！");
        Validate.notBlank(auditInvoiceManageDto.getIsMaterialInvoice(), "编辑时，是否实质性发票不能为空！");
        Validate.notBlank(auditInvoiceManageDto.getInvoiceType(), "新增时，发票类型不能为空！");
        //校验码，普票、电子普票、卷式普票必填；取值来源：发票上面校验码后 6位数字
        if (InvoiceTypeEnum.VAT_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType()) ||
                InvoiceTypeEnum.VATE_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType()) ||
                InvoiceTypeEnum.COIL_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType())) {
            Validate.notBlank(auditInvoiceManageDto.getCheckCode(), "新增时，校验码不能为空！");
        }
        //除全电票以外的发票传不含税金额；全电票需要传入含税金额；
        if (InvoiceTypeEnum.E_VAT_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType()) ||
                InvoiceTypeEnum.E_VATS_INVOICE.getCode().equals(auditInvoiceManageDto.getInvoiceType())) {
            Validate.notNull(auditInvoiceManageDto.getPriceAndTax(), "新增时，发票金额(含税)不能为空！");
        } else {
            Validate.notNull(auditInvoiceManageDto.getAmountWithoutTax(), "新增时，发票金额(未税)不能为空！");
        }
    }


    /**
     * 删除数据
     *
     * @param idList 主键结合
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<AuditInvoiceManage> rulesList = this.auditInvoiceManageRepository.listByIds(idList);
        ArrayList<AuditInvoiceManage> auditInvoiceManages = new ArrayList<>();
        rulesList.forEach(item -> {
            AuditInvoiceManage invoice = new AuditInvoiceManage();
            invoice.setId(item.getId());
            invoice.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            invoice.setInvoiceCrmCode(item.getInvoiceCrmCode());
            auditInvoiceManages.add(invoice);
            PageRequest page = PageRequest.of(1, 1);
            AuditInvoiceAuditDto auditInvoiceAuditDto = new AuditInvoiceAuditDto();
            auditInvoiceAuditDto.setInvoiceCrmCode(item.getInvoiceCrmCode());
            Page<AuditInvoiceAuditVo> auditInvoiceAuditVoPage = this.findAuditByConditions(page, auditInvoiceAuditDto);
            List<AuditInvoiceAuditVo> records = auditInvoiceAuditVoPage.getRecords();
            Validate.isTrue(CollectionUtils.isEmpty(records), "发票代码：" + item.getInvoiceCode() + "，发票号码：" + item.getInvoiceNo() + "存在关联的核销单，不能删除");

            //删除业务日志
            AuditInvoiceManageLogEventDto logEventDto = new AuditInvoiceManageLogEventDto();
            AuditInvoiceManageVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditInvoiceManageVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            AuditInvoiceManageDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditInvoiceManageDto.class, null, null);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<AuditInvoiceManageEventListener, AuditInvoiceManageLogEventDto> onDelete =
                    AuditInvoiceManageEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto, AuditInvoiceManageEventListener.class, onDelete);
        });
        this.auditInvoiceManageRepository.updateBatchById(auditInvoiceManages);
        //删除附件信息
        List<String> crmCodes = auditInvoiceManages.stream().map(AuditInvoiceManage::getInvoiceCrmCode).collect(Collectors.toList());
        this.auditInvoiceManageFileRepository.delFile(crmCodes);
        //删除明细
        this.auditInvoiceManageItemRepository.delItem(crmCodes);
    }

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<AuditInvoiceManage> activityApplyRuless = this.auditInvoiceManageRepository.listByIds(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(activityApplyRuless), "不存在或已删除!");

        ArrayList<AuditInvoiceManage> activityApplyRuleList = new ArrayList<>();
        activityApplyRuless.forEach(item -> {
            AuditInvoiceManage invoice = new AuditInvoiceManage();
            invoice.setId(item.getId());
            invoice.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            activityApplyRuleList.add(invoice);

            //启用业务日志
            AuditInvoiceManageLogEventDto logEventDto = new AuditInvoiceManageLogEventDto();
            AuditInvoiceManageVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditInvoiceManageVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            AuditInvoiceManageDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditInvoiceManageDto.class, null, null);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<AuditInvoiceManageEventListener, AuditInvoiceManageLogEventDto> onEnable =
                    AuditInvoiceManageEventListener::onEnable;
            this.nebulaNetEventClient.publish(logEventDto, AuditInvoiceManageEventListener.class, onEnable);
        });
        this.auditInvoiceManageRepository.updateBatchById(activityApplyRuleList);
    }

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<AuditInvoiceManage> activityApplyRuless = this.auditInvoiceManageRepository.listByIds(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(activityApplyRuless), "不存在或已删除!");

        ArrayList<AuditInvoiceManage> auditInvoiceManages = new ArrayList<>();
        activityApplyRuless.forEach(item -> {
            AuditInvoiceManage invoice = new AuditInvoiceManage();
            invoice.setId(item.getId());
            invoice.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            auditInvoiceManages.add(invoice);

            //禁用业务日志
            AuditInvoiceManageLogEventDto logEventDto = new AuditInvoiceManageLogEventDto();
            AuditInvoiceManageVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditInvoiceManageVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            AuditInvoiceManageDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditInvoiceManageDto.class, null, null);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<AuditInvoiceManageEventListener, AuditInvoiceManageLogEventDto> onDisable =
                    AuditInvoiceManageEventListener::onDisable;
            this.nebulaNetEventClient.publish(logEventDto, AuditInvoiceManageEventListener.class, onDisable);
        });
        this.auditInvoiceManageRepository.updateBatchById(auditInvoiceManages);
    }

    @Override
    public List<AuditInvoiceManageVo> findInvoices(Set<String> invoiceCodes) {
        Validate.isTrue(!CollectionUtils.isEmpty(invoiceCodes), "发票号码不能为空");
        List<AuditInvoiceManage> list = this.auditInvoiceManageRepository.lambdaQuery().in(AuditInvoiceManage::getInvoiceNo, invoiceCodes)
                .eq(AuditInvoiceManage::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditInvoiceManage::getEnableStatus, EnableStatusEnum.ENABLE.getCode()).list();
        if (!CollectionUtils.isEmpty(list)) {
            Collection<AuditInvoiceManageVo> auditInvoiceManageVos = this.nebulaToolkitService.copyCollectionByBlankList(list, AuditInvoiceManage.class, AuditInvoiceManageVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<AuditInvoiceManageVo>) auditInvoiceManageVos;
        }
        return new ArrayList<>();
    }

    /**
     * 分页查询关联核销明细
     *
     * @param pageable 分页对象
     * @param auditDto 查询dto
     * @return 所有数据
     */
    @Override
    public Page<AuditInvoiceAuditVo> findAuditByConditions(Pageable pageable, AuditInvoiceAuditDto auditDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(auditDto)) {
            auditDto = new AuditInvoiceAuditDto();
        }
        Validate.notBlank(auditDto.getInvoiceCrmCode(), "发票编码不能为空");
        auditDto.setTenantCode(TenantUtils.getTenantCode());
        //核销使用
        Page<AuditInvoiceAuditVo> page = this.auditInvoiceManageRepository.findAuditByConditions(pageable, auditDto);
        if (!CollectionUtils.isEmpty(page.getRecords())) {
            for (AuditInvoiceAuditVo record : page.getRecords()) {
                if (BooleanEnum.TRUE.getCapital().equals(record.getWholeAudit())) {
                    record.setSurplusAuditAmount(BigDecimal.ZERO);
                } else {
                    record.setSurplusAuditAmount(record.getAuditAmount().subtract(record.getAlreadyAuditAmount()));
                }
            }
        }else {
            //直接上账使用
            page = this.auditInvoiceManageRepository.findForAuditHandleByInvoiceCrmCode(pageable,auditDto.getInvoiceCrmCode());

        }
        return page;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void changeInvoices(List<AuditInvoiceManageDto> auditInvoiceManageDtos) {
        Validate.isTrue(!CollectionUtils.isEmpty(auditInvoiceManageDtos), "更改发票的数据不能为空");
        List<AuditInvoiceManage> auditInvoiceManageList = this.auditInvoiceManageRepository.findByCodeAndNo(auditInvoiceManageDtos);
        List<AuditInvoiceManage> auditInvoiceManageListUpdate = new ArrayList<>();
        auditInvoiceManageList.forEach(item -> {
            AuditInvoiceManage auditInvoiceManage = new AuditInvoiceManage();
            auditInvoiceManage.setId(item.getId());
//            auditInvoiceManage.setUse("Y");
            auditInvoiceManageListUpdate.add(auditInvoiceManage);
        });
        this.auditInvoiceManageRepository.updateBatchById(auditInvoiceManageListUpdate);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void returnInvoices(List<AuditInvoiceManageDto> auditInvoiceManageDtos) {
        Validate.isTrue(!CollectionUtils.isEmpty(auditInvoiceManageDtos), "更改发票的数据不能为空");
        List<AuditInvoiceManage> auditInvoiceManageList = this.auditInvoiceManageRepository.findByCodeAndNo(auditInvoiceManageDtos);
        List<AuditInvoiceManage> auditInvoiceManageListUpdate = new ArrayList<>();
        auditInvoiceManageList.forEach(item -> {
            AuditInvoiceManage auditInvoiceManage = new AuditInvoiceManage();
            auditInvoiceManage.setId(item.getId());
//            auditInvoiceManage.setUse("N");
            auditInvoiceManageListUpdate.add(auditInvoiceManage);
        });
        this.auditInvoiceManageRepository.updateBatchById(auditInvoiceManageListUpdate);
    }

    /**
     * 通过发票号码和发票代码(可为空)查询单条数据，若代码为0则视为空
     *
     * @param dto 参数
     * @return 单条数据
     */
    @Override
    public AuditInvoiceManageVo findByNoAndCode(AuditInvoiceManageDto dto) {
        Validate.notBlank(dto.getInvoiceNo(), "发票号码不能为空");
        if (StringUtils.isBlank(dto.getInvoiceCode())) {
            return null;
        }
        AuditInvoiceManage invoice = null;
        if (StringUtils.isNotBlank(dto.getInvoiceCode())
                && !AuditInvoiceManageConstant.ZERO.equals(dto.getInvoiceCode())) {
            invoice = this.auditInvoiceManageRepository.lambdaQuery()
                    .eq(AuditInvoiceManage::getInvoiceNo, dto.getInvoiceNo())
                    .eq(AuditInvoiceManage::getInvoiceCode, dto.getInvoiceCode())
                    .eq(AuditInvoiceManage::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .eq(AuditInvoiceManage::getTenantCode, TenantUtils.getTenantCode())
                    .one();
        } else {
            invoice = this.auditInvoiceManageRepository.lambdaQuery()
                    .eq(AuditInvoiceManage::getInvoiceNo, dto.getInvoiceNo())
                    .isNull(AuditInvoiceManage::getInvoiceCode)
                    .eq(AuditInvoiceManage::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .eq(AuditInvoiceManage::getTenantCode, TenantUtils.getTenantCode())
                    .one();
        }

        if (null == invoice) {
            return null;
        }
        AuditInvoiceManageVo manageVo = this.nebulaToolkitService.copyObjectByWhiteList(invoice, AuditInvoiceManageVo.class, null, null);
        List<AuditInvoiceManageItem> itemList = this.auditInvoiceManageItemRepository.lambdaQuery()
                .eq(AuditInvoiceManageItem::getInvoiceNo, invoice.getInvoiceNo())
                .eq(AuditInvoiceManageItem::getInvoiceCrmCode, invoice.getInvoiceCrmCode())
                .eq(AuditInvoiceManageItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if (!CollectionUtils.isEmpty(itemList)) {
            Collection<AuditInvoiceManageItemVo> itemVoList = this.nebulaToolkitService.copyCollectionByWhiteList(itemList, AuditInvoiceManageItem.class, AuditInvoiceManageItemVo.class, HashSet.class, ArrayList.class);
            manageVo.setLineList((List<AuditInvoiceManageItemVo>) itemVoList);
        }
        return manageVo;
    }

    /**
     * 根据编码查发票明细
     *
     * @return
     */
    @Override
    public List<AuditInvoiceItemVo> findByInvoiceNoCode(List<AuditInvoiceManageDto> auditInvoiceManageDtos) {
        Validate.isTrue(!CollectionUtils.isEmpty(auditInvoiceManageDtos), "参数信息不能为空");
        List<AuditInvoiceItemVo> list = this.auditInvoiceManageRepository.findByInvoiceNoCode(auditInvoiceManageDtos);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>();
        }
        for (AuditInvoiceItemVo invoiceItemVo : list) {
            BigDecimal taxAmount = invoiceItemVo.getTaxAmount();
            taxAmount = Objects.nonNull(taxAmount) ? taxAmount : BigDecimal.ZERO;
            BigDecimal invoiceAmount = invoiceItemVo.getInvoiceAmount();
            invoiceAmount = Objects.nonNull(invoiceAmount) ? invoiceAmount : BigDecimal.ZERO;
            invoiceItemVo.setInvoiceTaxAmount(taxAmount.add(invoiceAmount));
//            String taxRate = invoiceItemVo.getTaxRate();
//            if (StringUtils.isNotBlank(taxRate)) {
//                invoiceItemVo.setTaxRate(String.valueOf(new BigDecimal(taxRate).divide(new BigDecimal(100))));
//            } else {
//                invoiceItemVo.setTaxRate("0");
//            }
        }
        return list;
    }
    /**
     * 根据编码查发票明细
     *
     * @return
     */
    @Override
    public List<AuditInvoiceItemVo> findInvoiceItem(String invoiceCode, String invoiceNumber) {
        Validate.isTrue(StringUtils.isNotBlank(invoiceNumber),"发票号码不能为空！");
        List<AuditInvoiceItemVo> list = this.auditInvoiceManageRepository.findInvoiceItem(invoiceCode,invoiceNumber);
        for (AuditInvoiceItemVo invoiceItemVo : list) {
            BigDecimal taxAmount = invoiceItemVo.getTaxAmount();
            taxAmount = Objects.nonNull(taxAmount) ? taxAmount : BigDecimal.ZERO;
            BigDecimal invoiceAmount = invoiceItemVo.getInvoiceAmount();
            invoiceAmount = Objects.nonNull(invoiceAmount) ? invoiceAmount : BigDecimal.ZERO;
            invoiceItemVo.setInvoiceTaxAmount(taxAmount.add(invoiceAmount));
        }
        return list;
    }

    @Override
    public Page<AuditInvoiceManageItemExportVo> findAllConditions(Pageable pageable, AuditInvoiceManageDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new AuditInvoiceManageDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page<AuditInvoiceManageItemExportVo> itemExportVoPage = auditInvoiceManageRepository.findAllConditions(pageable, dto);
        List<AuditInvoiceManageItemExportVo> records = itemExportVoPage.getRecords();
        if (CollectionUtils.isEmpty(records)) {
            return itemExportVoPage;
        }
        for (AuditInvoiceManageItemExportVo invoiceItemVo : records) {
            BigDecimal taxAmount = invoiceItemVo.getTax();
            taxAmount = Objects.nonNull(taxAmount) ? taxAmount : BigDecimal.ZERO;
            BigDecimal invoiceAmount = invoiceItemVo.getAmount();
            invoiceAmount = Objects.nonNull(invoiceAmount) ? invoiceAmount : BigDecimal.ZERO;
            invoiceItemVo.setInvoiceTaxAmount(taxAmount.add(invoiceAmount));
        }
        return itemExportVoPage.setRecords(records);
    }

    /**
     * 更新发票使用状态
     *
     * @param invoiceManageDtoList
     */
    @Override
    public void updateByNoAndCode(List<AuditInvoiceManageDto> invoiceManageDtoList, String isUse, String useDate) {
        if (CollectionUtils.isEmpty(invoiceManageDtoList) || StringUtils.isBlank(isUse)) {
            return;
        }
        auditInvoiceManageRepository.updateByNoAndCode(invoiceManageDtoList, isUse, useDate);
    }

    /**
     * 根据发票id查询发票附件
     *
     * @param ids
     * @return
     */
    @Override
    public List<AuditInvoiceManageFileSdkVo> findInvoiceFileData(List<String> ids) {
        Validate.notNull(ids, "查询附件的发票id不能为空！");
        List<AuditInvoiceManage> list = this.auditInvoiceManageRepository.listByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Set<String> codes = list.stream().map(AuditInvoiceManage::getInvoiceCrmCode).collect(Collectors.toSet());
        List<AuditInvoiceManageFile> fileList = this.auditInvoiceManageFileRepository.findByInvoiceCrmCode(codes);
        if (CollectionUtils.isEmpty(fileList)) {
            return null;
        }
        return (List<AuditInvoiceManageFileSdkVo>) this.nebulaToolkitService.copyCollectionByWhiteList(fileList, AuditInvoiceManageFile.class, AuditInvoiceManageFileSdkVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<AuditInvoiceManageVo> findByInvoiceNoCode2(List<AuditInvoiceManageDto> dtoList) {
        if(CollectionUtils.isEmpty(dtoList)){
            return Lists.newArrayList();
        }
        List<AuditInvoiceManage> auditInvoiceManageList = this.auditInvoiceManageRepository.findByCodeAndNo(dtoList);
        if(CollectionUtils.isEmpty(auditInvoiceManageList)){
            Collection<AuditInvoiceManageVo> auditInvoiceManageVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditInvoiceManageList, AuditInvoiceManage.class, AuditInvoiceManageVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<AuditInvoiceManageVo>) auditInvoiceManageVos;
        }
        return Lists.newArrayList();
    }

    /**
     * 根据发票id下载附件压缩包
     *
     * @param ids id列表
     * @return byte[]
     * @throws IOException 异常
     */
    @Override
    public byte[] findFileZipByIds(List<String> ids) throws IOException {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<AuditInvoiceManage> list = this.auditInvoiceManageRepository.listByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Set<String> codes = list.stream().map(AuditInvoiceManage::getInvoiceCrmCode).collect(Collectors.toSet());
        List<AuditInvoiceManageFile> fileList = this.auditInvoiceManageFileRepository.findByInvoiceCrmCode(codes);
        if (CollectionUtils.isEmpty(fileList)) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(bos);
        for (AuditInvoiceManageFile file : fileList) {
            byte[] fileBytes = fileHandleService.findContentByFilePathAndFileRename(file.getRelativeLocal(), file.getFileName());
            zipOut.putNextEntry(new ZipEntry(file.getOriginalFileName()));
            zipOut.write(fileBytes, 0, fileBytes.length);
            zipOut.closeEntry();
        }
        zipOut.flush();
        zipOut.close();
        return bos.toByteArray();
    }

    /**
     * 根据发票号码下载附件压缩包
     *
     * @param invoiceNos 号码列表
     * @return byte[]
     * @throws IOException 异常
     */
    @Override
    public byte[] findFileZipByInvoiveNos(List<String> invoiceNos) throws IOException {
        if (CollectionUtils.isEmpty(invoiceNos)) {
            return null;
        }
        List<AuditInvoiceManage> list = this.auditInvoiceManageRepository.lambdaQuery()
                .eq(AuditInvoiceManage::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditInvoiceManage::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditInvoiceManage::getInvoiceNo, invoiceNos)
                .list();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Set<String> codes = list.stream().map(AuditInvoiceManage::getInvoiceCrmCode).collect(Collectors.toSet());
        List<AuditInvoiceManageFile> fileList = this.auditInvoiceManageFileRepository.lambdaQuery()
                .in(AuditInvoiceManageFile::getInvoiceCrmCode, codes)
                .eq(AuditInvoiceManageFile::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if (CollectionUtils.isEmpty(fileList)) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(bos);
        for (AuditInvoiceManageFile file : fileList) {
            byte[] fileBytes = fileHandleService.findContentByFilePathAndFileRename(file.getRelativeLocal(), file.getFileName());
            zipOut.putNextEntry(new ZipEntry(file.getOriginalFileName()));
            zipOut.write(fileBytes, 0, fileBytes.length);
            zipOut.closeEntry();
        }
        zipOut.flush();
        zipOut.close();
        return bos.toByteArray();
    }

    /**
     * 组装发票明细数据
     *
     * @param fpmxjh 发票明细
     * @param code   编码
     * @param fphm   发票号码
     * @return List<AuditInvoiceManageItem>
     */
    public List<AuditInvoiceManageItem> packageItemDate(List<InvoiceCheckItemVo> fpmxjh, String code, String fphm) {
        if (CollectionUtils.isEmpty(fpmxjh)) {
            return new ArrayList<>();
        }
        String tenantCode = TenantUtils.getTenantCode();
        List<AuditInvoiceManageItem> itemList = new ArrayList<>();
        for (InvoiceCheckItemVo vo : fpmxjh) {
            AuditInvoiceManageItem item = new AuditInvoiceManageItem();
            item.setTenantCode(tenantCode);
            item.setInvoiceCrmCode(code);
            item.setInvoiceNo(fphm);
            item.setItemNo(vo.getHh());
            item.setGoodsCode(vo.getSpbm());
            item.setGoodsTaxableName(vo.getHwhyslwmc());
            item.setSpecModel(vo.getGgxh());
            item.setUnitSeat(vo.getDw());
            try {
                if (StringUtils.isNotBlank(vo.getGmsl())) {
                    item.setPurchaseQuantity(new BigDecimal(vo.getGmsl()));
                }
                if (StringUtils.isNotBlank(vo.getDj())) {
                    item.setUnitPrice(new BigDecimal(vo.getDj()));
                }
                if (StringUtils.isNotBlank(vo.getJe())) {
                    item.setAmount(new BigDecimal(vo.getJe()));
                }
                if (StringUtils.isNotBlank(vo.getSl())) {
                    item.setTaxRate(new BigDecimal(vo.getSl()));
                }
                if (StringUtils.isNotBlank(vo.getSe())) {
                    item.setTax(new BigDecimal(vo.getSe()));
                }
            } catch (Exception e) {
                log.error("发票明细类型转换异常：{}", e.getMessage());
            }
            item.setCarLicense(vo.getCph());
            item.setStartDate(vo.getTxrqs());
            item.setEndDate(vo.getTxrqz());
            item.setExitStation(vo.getCkz());
            item.setEntranceStation(vo.getRkz());
            itemList.add(item);
        }
        return itemList;
    }
}
