package com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author: chenlong
 * @date: 2022/11/14 9:48
 * @description: 结案核销发票管理-关联核销明细Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditInvoiceAuditDto", description = "结案核销发票管理-关联核销明细Dto")
public class AuditInvoiceAuditDto extends TenantFlagOpDto {

    @ApiModelProperty("发票编码(系统自动生成)")
    private String invoiceCrmCode;

    @ApiModelProperty("发票代码")
    private String invoiceCode;

    @ApiModelProperty("发票号码(只允许填写数字和字母)")
    private String invoiceNo;

    @ApiModelProperty(name = "核销code", notes = "核销code")
    private String auditCode;

    @ApiModelProperty(name = "核销名称", notes = "核销名称")
    private String auditName;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "零售商编码", notes = "零售商编码")
    private String systemCode;

    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    private String systemName;
}
