package com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author : dengwei
 * @Date :2023/8/30  14:39
 * @Description: 核销发票监听
 */
@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AuditInvoiceEventDto implements NebulaEventDto {

    List<Item> items = new ArrayList<>();

    @Data
    public static class Item{
        @ApiModelProperty("发票代码")
        private String invoiceCode;

        @ApiModelProperty("发票号码(只允许填写数字和字母)")
        private String invoiceNo;
    }

}
